<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for INI ServiceType
 * @subpackage Services
 */
class INI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IN202500Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN202500Import $parameters
     * @return \StructType\IN202500ImportResponse|bool
     */
    public function IN202500Import(\StructType\IN202500Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN202500Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN304000Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN304000Import $parameters
     * @return \StructType\IN304000ImportResponse|bool
     */
    public function IN304000Import(\StructType\IN304000Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN304000Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IN202500ImportResponse|\StructType\IN304000ImportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
