<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ING ServiceType
 * @subpackage Services
 */
class ING extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IN202500GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN202500GetProcessStatus $parameters
     * @return \StructType\IN202500GetProcessStatusResponse|bool
     */
    public function IN202500GetProcessStatus(\StructType\IN202500GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN202500GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN202500GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN202500GetSchema $parameters
     * @return \StructType\IN202500GetSchemaResponse|bool
     */
    public function IN202500GetSchema(\StructType\IN202500GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN202500GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN304000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN304000GetProcessStatus $parameters
     * @return \StructType\IN304000GetProcessStatusResponse|bool
     */
    public function IN304000GetProcessStatus(\StructType\IN304000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN304000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN304000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN304000GetSchema $parameters
     * @return \StructType\IN304000GetSchemaResponse|bool
     */
    public function IN304000GetSchema(\StructType\IN304000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN304000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IN202500GetProcessStatusResponse|\StructType\IN202500GetSchemaResponse|\StructType\IN304000GetProcessStatusResponse|\StructType\IN304000GetSchemaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
