<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for INC ServiceType
 * @subpackage Services
 */
class INC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IN202500Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN202500Clear $parameters
     * @return \StructType\IN202500ClearResponse|bool
     */
    public function IN202500Clear(\StructType\IN202500Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN202500Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN304000Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN304000Clear $parameters
     * @return \StructType\IN304000ClearResponse|bool
     */
    public function IN304000Clear(\StructType\IN304000Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN304000Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IN202500ClearResponse|\StructType\IN304000ClearResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
