<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GLS ServiceType
 * @subpackage Services
 */
class GLS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GL301000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GL301000SetSchema $parameters
     * @return \StructType\GL301000SetSchemaResponse|bool
     */
    public function GL301000SetSchema(\StructType\GL301000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GL301000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GL301000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GL301000Submit $parameters
     * @return \StructType\GL301000SubmitResponse|bool
     */
    public function GL301000Submit(\StructType\GL301000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GL301000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GL301000SetSchemaResponse|\StructType\GL301000SubmitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
