<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GLG ServiceType
 * @subpackage Services
 */
class GLG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GL301000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GL301000GetProcessStatus $parameters
     * @return \StructType\GL301000GetProcessStatusResponse|bool
     */
    public function GL301000GetProcessStatus(\StructType\GL301000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GL301000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GL301000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GL301000GetSchema $parameters
     * @return \StructType\GL301000GetSchemaResponse|bool
     */
    public function GL301000GetSchema(\StructType\GL301000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GL301000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GL301000GetProcessStatusResponse|\StructType\GL301000GetSchemaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
