<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GLC ServiceType
 * @subpackage Services
 */
class GLC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GL301000Clear
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GL301000Clear $parameters
     * @return \StructType\GL301000ClearResponse|bool
     */
    public function GL301000Clear(\StructType\GL301000Clear $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GL301000Clear($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GL301000ClearResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
