<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO302000Export StructType
 * @subpackage Structs
 */
class SO302000Export extends AbstractStructBase
{
    /**
     * The topCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $topCount;
    /**
     * The includeHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeHeaders;
    /**
     * The breakOnError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $breakOnError;
    /**
     * The commands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommand
     */
    public $commands;
    /**
     * The filters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFilter
     */
    public $filters;
    /**
     * Constructor method for SO302000Export
     * @uses SO302000Export::setTopCount()
     * @uses SO302000Export::setIncludeHeaders()
     * @uses SO302000Export::setBreakOnError()
     * @uses SO302000Export::setCommands()
     * @uses SO302000Export::setFilters()
     * @param int $topCount
     * @param bool $includeHeaders
     * @param bool $breakOnError
     * @param \ArrayType\ArrayOfCommand $commands
     * @param \ArrayType\ArrayOfFilter $filters
     */
    public function __construct($topCount = null, $includeHeaders = null, $breakOnError = null, \ArrayType\ArrayOfCommand $commands = null, \ArrayType\ArrayOfFilter $filters = null)
    {
        $this
            ->setTopCount($topCount)
            ->setIncludeHeaders($includeHeaders)
            ->setBreakOnError($breakOnError)
            ->setCommands($commands)
            ->setFilters($filters);
    }
    /**
     * Get topCount value
     * @return int
     */
    public function getTopCount()
    {
        return $this->topCount;
    }
    /**
     * Set topCount value
     * @param int $topCount
     * @return \StructType\SO302000Export
     */
    public function setTopCount($topCount = null)
    {
        // validation for constraint: int
        if (!is_null($topCount) && !is_numeric($topCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($topCount)), __LINE__);
        }
        $this->topCount = $topCount;
        return $this;
    }
    /**
     * Get includeHeaders value
     * @return bool
     */
    public function getIncludeHeaders()
    {
        return $this->includeHeaders;
    }
    /**
     * Set includeHeaders value
     * @param bool $includeHeaders
     * @return \StructType\SO302000Export
     */
    public function setIncludeHeaders($includeHeaders = null)
    {
        $this->includeHeaders = $includeHeaders;
        return $this;
    }
    /**
     * Get breakOnError value
     * @return bool
     */
    public function getBreakOnError()
    {
        return $this->breakOnError;
    }
    /**
     * Set breakOnError value
     * @param bool $breakOnError
     * @return \StructType\SO302000Export
     */
    public function setBreakOnError($breakOnError = null)
    {
        $this->breakOnError = $breakOnError;
        return $this;
    }
    /**
     * Get commands value
     * @return \ArrayType\ArrayOfCommand|null
     */
    public function getCommands()
    {
        return $this->commands;
    }
    /**
     * Set commands value
     * @param \ArrayType\ArrayOfCommand $commands
     * @return \StructType\SO302000Export
     */
    public function setCommands(\ArrayType\ArrayOfCommand $commands = null)
    {
        $this->commands = $commands;
        return $this;
    }
    /**
     * Get filters value
     * @return \ArrayType\ArrayOfFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \ArrayType\ArrayOfFilter $filters
     * @return \StructType\SO302000Export
     */
    public function setFilters(\ArrayType\ArrayOfFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO302000Export
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
