<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO302000AddSalesOrderOperation StructType
 * @subpackage Structs
 */
class SO302000AddSalesOrderOperation extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Operation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Operation;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SO302000AddSalesOrderOperationServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SO302000AddSalesOrderOperation
     * @uses SO302000AddSalesOrderOperation::setDisplayName()
     * @uses SO302000AddSalesOrderOperation::setOperation()
     * @uses SO302000AddSalesOrderOperation::setOrderType()
     * @uses SO302000AddSalesOrderOperation::setOrderNbr()
     * @uses SO302000AddSalesOrderOperation::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $operation
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\SO302000AddSalesOrderOperationServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $operation = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\SO302000AddSalesOrderOperationServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setOperation($operation)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SO302000AddSalesOrderOperation
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Operation value
     * @return \StructType\Field|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param \StructType\Field $operation
     * @return \StructType\SO302000AddSalesOrderOperation
     */
    public function setOperation(\StructType\Field $operation = null)
    {
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\SO302000AddSalesOrderOperation
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\SO302000AddSalesOrderOperation
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SO302000AddSalesOrderOperationServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SO302000AddSalesOrderOperationServiceCommands $serviceCommands
     * @return \StructType\SO302000AddSalesOrderOperation
     */
    public function setServiceCommands(\StructType\SO302000AddSalesOrderOperationServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO302000AddSalesOrderOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
