<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO301000PaymentSettings StructType
 * @subpackage Structs
 */
class SO301000PaymentSettings extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PaymentMethod;
    /**
     * The CardAccountNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CardAccountNo;
    /**
     * The CardAccountNoIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CardAccountNoIdentifier;
    /**
     * The CashAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CashAccount;
    /**
     * The PaymentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PaymentRef;
    /**
     * The CCNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CCNumber;
    /**
     * The NewCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NewCard;
    /**
     * The ProcessingStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProcessingStatus;
    /**
     * The PCResponseReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PCResponseReason;
    /**
     * The PreAuthNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PreAuthNbr;
    /**
     * The AuthExpiresOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AuthExpiresOn;
    /**
     * The PreAuthorizedAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PreAuthorizedAmount;
    /**
     * The PaymentsTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PaymentsTotal;
    /**
     * The UnpaidBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnpaidBalance;
    /**
     * The CaptureTranNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CaptureTranNbr;
    /**
     * The OrigPCRefNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrigPCRefNbr;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SO301000PaymentSettingsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SO301000PaymentSettings
     * @uses SO301000PaymentSettings::setDisplayName()
     * @uses SO301000PaymentSettings::setPaymentMethod()
     * @uses SO301000PaymentSettings::setCardAccountNo()
     * @uses SO301000PaymentSettings::setCardAccountNoIdentifier()
     * @uses SO301000PaymentSettings::setCashAccount()
     * @uses SO301000PaymentSettings::setPaymentRef()
     * @uses SO301000PaymentSettings::setCCNumber()
     * @uses SO301000PaymentSettings::setNewCard()
     * @uses SO301000PaymentSettings::setProcessingStatus()
     * @uses SO301000PaymentSettings::setPCResponseReason()
     * @uses SO301000PaymentSettings::setPreAuthNbr()
     * @uses SO301000PaymentSettings::setAuthExpiresOn()
     * @uses SO301000PaymentSettings::setPreAuthorizedAmount()
     * @uses SO301000PaymentSettings::setPaymentsTotal()
     * @uses SO301000PaymentSettings::setUnpaidBalance()
     * @uses SO301000PaymentSettings::setCaptureTranNbr()
     * @uses SO301000PaymentSettings::setOrigPCRefNbr()
     * @uses SO301000PaymentSettings::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $paymentMethod
     * @param \StructType\Field $cardAccountNo
     * @param \StructType\Field $cardAccountNoIdentifier
     * @param \StructType\Field $cashAccount
     * @param \StructType\Field $paymentRef
     * @param \StructType\Field $cCNumber
     * @param \StructType\Field $newCard
     * @param \StructType\Field $processingStatus
     * @param \StructType\Field $pCResponseReason
     * @param \StructType\Field $preAuthNbr
     * @param \StructType\Field $authExpiresOn
     * @param \StructType\Field $preAuthorizedAmount
     * @param \StructType\Field $paymentsTotal
     * @param \StructType\Field $unpaidBalance
     * @param \StructType\Field $captureTranNbr
     * @param \StructType\Field $origPCRefNbr
     * @param \StructType\SO301000PaymentSettingsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $paymentMethod = null, \StructType\Field $cardAccountNo = null, \StructType\Field $cardAccountNoIdentifier = null, \StructType\Field $cashAccount = null, \StructType\Field $paymentRef = null, \StructType\Field $cCNumber = null, \StructType\Field $newCard = null, \StructType\Field $processingStatus = null, \StructType\Field $pCResponseReason = null, \StructType\Field $preAuthNbr = null, \StructType\Field $authExpiresOn = null, \StructType\Field $preAuthorizedAmount = null, \StructType\Field $paymentsTotal = null, \StructType\Field $unpaidBalance = null, \StructType\Field $captureTranNbr = null, \StructType\Field $origPCRefNbr = null, \StructType\SO301000PaymentSettingsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setPaymentMethod($paymentMethod)
            ->setCardAccountNo($cardAccountNo)
            ->setCardAccountNoIdentifier($cardAccountNoIdentifier)
            ->setCashAccount($cashAccount)
            ->setPaymentRef($paymentRef)
            ->setCCNumber($cCNumber)
            ->setNewCard($newCard)
            ->setProcessingStatus($processingStatus)
            ->setPCResponseReason($pCResponseReason)
            ->setPreAuthNbr($preAuthNbr)
            ->setAuthExpiresOn($authExpiresOn)
            ->setPreAuthorizedAmount($preAuthorizedAmount)
            ->setPaymentsTotal($paymentsTotal)
            ->setUnpaidBalance($unpaidBalance)
            ->setCaptureTranNbr($captureTranNbr)
            ->setOrigPCRefNbr($origPCRefNbr)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SO301000PaymentSettings
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \StructType\Field|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \StructType\Field $paymentMethod
     * @return \StructType\SO301000PaymentSettings
     */
    public function setPaymentMethod(\StructType\Field $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get CardAccountNo value
     * @return \StructType\Field|null
     */
    public function getCardAccountNo()
    {
        return $this->CardAccountNo;
    }
    /**
     * Set CardAccountNo value
     * @param \StructType\Field $cardAccountNo
     * @return \StructType\SO301000PaymentSettings
     */
    public function setCardAccountNo(\StructType\Field $cardAccountNo = null)
    {
        $this->CardAccountNo = $cardAccountNo;
        return $this;
    }
    /**
     * Get CardAccountNoIdentifier value
     * @return \StructType\Field|null
     */
    public function getCardAccountNoIdentifier()
    {
        return $this->CardAccountNoIdentifier;
    }
    /**
     * Set CardAccountNoIdentifier value
     * @param \StructType\Field $cardAccountNoIdentifier
     * @return \StructType\SO301000PaymentSettings
     */
    public function setCardAccountNoIdentifier(\StructType\Field $cardAccountNoIdentifier = null)
    {
        $this->CardAccountNoIdentifier = $cardAccountNoIdentifier;
        return $this;
    }
    /**
     * Get CashAccount value
     * @return \StructType\Field|null
     */
    public function getCashAccount()
    {
        return $this->CashAccount;
    }
    /**
     * Set CashAccount value
     * @param \StructType\Field $cashAccount
     * @return \StructType\SO301000PaymentSettings
     */
    public function setCashAccount(\StructType\Field $cashAccount = null)
    {
        $this->CashAccount = $cashAccount;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return \StructType\Field|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param \StructType\Field $paymentRef
     * @return \StructType\SO301000PaymentSettings
     */
    public function setPaymentRef(\StructType\Field $paymentRef = null)
    {
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get CCNumber value
     * @return \StructType\Field|null
     */
    public function getCCNumber()
    {
        return $this->CCNumber;
    }
    /**
     * Set CCNumber value
     * @param \StructType\Field $cCNumber
     * @return \StructType\SO301000PaymentSettings
     */
    public function setCCNumber(\StructType\Field $cCNumber = null)
    {
        $this->CCNumber = $cCNumber;
        return $this;
    }
    /**
     * Get NewCard value
     * @return \StructType\Field|null
     */
    public function getNewCard()
    {
        return $this->NewCard;
    }
    /**
     * Set NewCard value
     * @param \StructType\Field $newCard
     * @return \StructType\SO301000PaymentSettings
     */
    public function setNewCard(\StructType\Field $newCard = null)
    {
        $this->NewCard = $newCard;
        return $this;
    }
    /**
     * Get ProcessingStatus value
     * @return \StructType\Field|null
     */
    public function getProcessingStatus()
    {
        return $this->ProcessingStatus;
    }
    /**
     * Set ProcessingStatus value
     * @param \StructType\Field $processingStatus
     * @return \StructType\SO301000PaymentSettings
     */
    public function setProcessingStatus(\StructType\Field $processingStatus = null)
    {
        $this->ProcessingStatus = $processingStatus;
        return $this;
    }
    /**
     * Get PCResponseReason value
     * @return \StructType\Field|null
     */
    public function getPCResponseReason()
    {
        return $this->PCResponseReason;
    }
    /**
     * Set PCResponseReason value
     * @param \StructType\Field $pCResponseReason
     * @return \StructType\SO301000PaymentSettings
     */
    public function setPCResponseReason(\StructType\Field $pCResponseReason = null)
    {
        $this->PCResponseReason = $pCResponseReason;
        return $this;
    }
    /**
     * Get PreAuthNbr value
     * @return \StructType\Field|null
     */
    public function getPreAuthNbr()
    {
        return $this->PreAuthNbr;
    }
    /**
     * Set PreAuthNbr value
     * @param \StructType\Field $preAuthNbr
     * @return \StructType\SO301000PaymentSettings
     */
    public function setPreAuthNbr(\StructType\Field $preAuthNbr = null)
    {
        $this->PreAuthNbr = $preAuthNbr;
        return $this;
    }
    /**
     * Get AuthExpiresOn value
     * @return \StructType\Field|null
     */
    public function getAuthExpiresOn()
    {
        return $this->AuthExpiresOn;
    }
    /**
     * Set AuthExpiresOn value
     * @param \StructType\Field $authExpiresOn
     * @return \StructType\SO301000PaymentSettings
     */
    public function setAuthExpiresOn(\StructType\Field $authExpiresOn = null)
    {
        $this->AuthExpiresOn = $authExpiresOn;
        return $this;
    }
    /**
     * Get PreAuthorizedAmount value
     * @return \StructType\Field|null
     */
    public function getPreAuthorizedAmount()
    {
        return $this->PreAuthorizedAmount;
    }
    /**
     * Set PreAuthorizedAmount value
     * @param \StructType\Field $preAuthorizedAmount
     * @return \StructType\SO301000PaymentSettings
     */
    public function setPreAuthorizedAmount(\StructType\Field $preAuthorizedAmount = null)
    {
        $this->PreAuthorizedAmount = $preAuthorizedAmount;
        return $this;
    }
    /**
     * Get PaymentsTotal value
     * @return \StructType\Field|null
     */
    public function getPaymentsTotal()
    {
        return $this->PaymentsTotal;
    }
    /**
     * Set PaymentsTotal value
     * @param \StructType\Field $paymentsTotal
     * @return \StructType\SO301000PaymentSettings
     */
    public function setPaymentsTotal(\StructType\Field $paymentsTotal = null)
    {
        $this->PaymentsTotal = $paymentsTotal;
        return $this;
    }
    /**
     * Get UnpaidBalance value
     * @return \StructType\Field|null
     */
    public function getUnpaidBalance()
    {
        return $this->UnpaidBalance;
    }
    /**
     * Set UnpaidBalance value
     * @param \StructType\Field $unpaidBalance
     * @return \StructType\SO301000PaymentSettings
     */
    public function setUnpaidBalance(\StructType\Field $unpaidBalance = null)
    {
        $this->UnpaidBalance = $unpaidBalance;
        return $this;
    }
    /**
     * Get CaptureTranNbr value
     * @return \StructType\Field|null
     */
    public function getCaptureTranNbr()
    {
        return $this->CaptureTranNbr;
    }
    /**
     * Set CaptureTranNbr value
     * @param \StructType\Field $captureTranNbr
     * @return \StructType\SO301000PaymentSettings
     */
    public function setCaptureTranNbr(\StructType\Field $captureTranNbr = null)
    {
        $this->CaptureTranNbr = $captureTranNbr;
        return $this;
    }
    /**
     * Get OrigPCRefNbr value
     * @return \StructType\Field|null
     */
    public function getOrigPCRefNbr()
    {
        return $this->OrigPCRefNbr;
    }
    /**
     * Set OrigPCRefNbr value
     * @param \StructType\Field $origPCRefNbr
     * @return \StructType\SO301000PaymentSettings
     */
    public function setOrigPCRefNbr(\StructType\Field $origPCRefNbr = null)
    {
        $this->OrigPCRefNbr = $origPCRefNbr;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SO301000PaymentSettingsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SO301000PaymentSettingsServiceCommands $serviceCommands
     * @return \StructType\SO301000PaymentSettings
     */
    public function setServiceCommands(\StructType\SO301000PaymentSettingsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO301000PaymentSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
