<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SO301000Allocations StructType
 * @subpackage Structs
 */
class SO301000Allocations extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The AllocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AllocationID;
    /**
     * The ParentAllocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ParentAllocationID;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The ShipOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipOn;
    /**
     * The Allocated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Allocated;
    /**
     * The AllocWarehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AllocWarehouse;
    /**
     * The Completed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Completed;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Quantity;
    /**
     * The QtyOnShipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyOnShipments;
    /**
     * The QtyReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyReceived;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The MarkForPO
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MarkForPO;
    /**
     * The RelatedDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RelatedDocument;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SO301000AllocationsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SO301000Allocations
     * @uses SO301000Allocations::setDisplayName()
     * @uses SO301000Allocations::setAllocationID()
     * @uses SO301000Allocations::setParentAllocationID()
     * @uses SO301000Allocations::setInventoryID()
     * @uses SO301000Allocations::setShipOn()
     * @uses SO301000Allocations::setAllocated()
     * @uses SO301000Allocations::setAllocWarehouse()
     * @uses SO301000Allocations::setCompleted()
     * @uses SO301000Allocations::setLocation()
     * @uses SO301000Allocations::setQuantity()
     * @uses SO301000Allocations::setQtyOnShipments()
     * @uses SO301000Allocations::setQtyReceived()
     * @uses SO301000Allocations::setUOM()
     * @uses SO301000Allocations::setMarkForPO()
     * @uses SO301000Allocations::setRelatedDocument()
     * @uses SO301000Allocations::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $allocationID
     * @param \StructType\Field $parentAllocationID
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $shipOn
     * @param \StructType\Field $allocated
     * @param \StructType\Field $allocWarehouse
     * @param \StructType\Field $completed
     * @param \StructType\Field $location
     * @param \StructType\Field $quantity
     * @param \StructType\Field $qtyOnShipments
     * @param \StructType\Field $qtyReceived
     * @param \StructType\Field $uOM
     * @param \StructType\Field $markForPO
     * @param \StructType\Field $relatedDocument
     * @param \StructType\SO301000AllocationsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $allocationID = null, \StructType\Field $parentAllocationID = null, \StructType\Field $inventoryID = null, \StructType\Field $shipOn = null, \StructType\Field $allocated = null, \StructType\Field $allocWarehouse = null, \StructType\Field $completed = null, \StructType\Field $location = null, \StructType\Field $quantity = null, \StructType\Field $qtyOnShipments = null, \StructType\Field $qtyReceived = null, \StructType\Field $uOM = null, \StructType\Field $markForPO = null, \StructType\Field $relatedDocument = null, \StructType\SO301000AllocationsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setAllocationID($allocationID)
            ->setParentAllocationID($parentAllocationID)
            ->setInventoryID($inventoryID)
            ->setShipOn($shipOn)
            ->setAllocated($allocated)
            ->setAllocWarehouse($allocWarehouse)
            ->setCompleted($completed)
            ->setLocation($location)
            ->setQuantity($quantity)
            ->setQtyOnShipments($qtyOnShipments)
            ->setQtyReceived($qtyReceived)
            ->setUOM($uOM)
            ->setMarkForPO($markForPO)
            ->setRelatedDocument($relatedDocument)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SO301000Allocations
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get AllocationID value
     * @return \StructType\Field|null
     */
    public function getAllocationID()
    {
        return $this->AllocationID;
    }
    /**
     * Set AllocationID value
     * @param \StructType\Field $allocationID
     * @return \StructType\SO301000Allocations
     */
    public function setAllocationID(\StructType\Field $allocationID = null)
    {
        $this->AllocationID = $allocationID;
        return $this;
    }
    /**
     * Get ParentAllocationID value
     * @return \StructType\Field|null
     */
    public function getParentAllocationID()
    {
        return $this->ParentAllocationID;
    }
    /**
     * Set ParentAllocationID value
     * @param \StructType\Field $parentAllocationID
     * @return \StructType\SO301000Allocations
     */
    public function setParentAllocationID(\StructType\Field $parentAllocationID = null)
    {
        $this->ParentAllocationID = $parentAllocationID;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\SO301000Allocations
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get ShipOn value
     * @return \StructType\Field|null
     */
    public function getShipOn()
    {
        return $this->ShipOn;
    }
    /**
     * Set ShipOn value
     * @param \StructType\Field $shipOn
     * @return \StructType\SO301000Allocations
     */
    public function setShipOn(\StructType\Field $shipOn = null)
    {
        $this->ShipOn = $shipOn;
        return $this;
    }
    /**
     * Get Allocated value
     * @return \StructType\Field|null
     */
    public function getAllocated()
    {
        return $this->Allocated;
    }
    /**
     * Set Allocated value
     * @param \StructType\Field $allocated
     * @return \StructType\SO301000Allocations
     */
    public function setAllocated(\StructType\Field $allocated = null)
    {
        $this->Allocated = $allocated;
        return $this;
    }
    /**
     * Get AllocWarehouse value
     * @return \StructType\Field|null
     */
    public function getAllocWarehouse()
    {
        return $this->AllocWarehouse;
    }
    /**
     * Set AllocWarehouse value
     * @param \StructType\Field $allocWarehouse
     * @return \StructType\SO301000Allocations
     */
    public function setAllocWarehouse(\StructType\Field $allocWarehouse = null)
    {
        $this->AllocWarehouse = $allocWarehouse;
        return $this;
    }
    /**
     * Get Completed value
     * @return \StructType\Field|null
     */
    public function getCompleted()
    {
        return $this->Completed;
    }
    /**
     * Set Completed value
     * @param \StructType\Field $completed
     * @return \StructType\SO301000Allocations
     */
    public function setCompleted(\StructType\Field $completed = null)
    {
        $this->Completed = $completed;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\SO301000Allocations
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Field|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Field $quantity
     * @return \StructType\SO301000Allocations
     */
    public function setQuantity(\StructType\Field $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * @return \StructType\Field|null
     */
    public function getQtyOnShipments()
    {
        return $this->QtyOnShipments;
    }
    /**
     * Set QtyOnShipments value
     * @param \StructType\Field $qtyOnShipments
     * @return \StructType\SO301000Allocations
     */
    public function setQtyOnShipments(\StructType\Field $qtyOnShipments = null)
    {
        $this->QtyOnShipments = $qtyOnShipments;
        return $this;
    }
    /**
     * Get QtyReceived value
     * @return \StructType\Field|null
     */
    public function getQtyReceived()
    {
        return $this->QtyReceived;
    }
    /**
     * Set QtyReceived value
     * @param \StructType\Field $qtyReceived
     * @return \StructType\SO301000Allocations
     */
    public function setQtyReceived(\StructType\Field $qtyReceived = null)
    {
        $this->QtyReceived = $qtyReceived;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\SO301000Allocations
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get MarkForPO value
     * @return \StructType\Field|null
     */
    public function getMarkForPO()
    {
        return $this->MarkForPO;
    }
    /**
     * Set MarkForPO value
     * @param \StructType\Field $markForPO
     * @return \StructType\SO301000Allocations
     */
    public function setMarkForPO(\StructType\Field $markForPO = null)
    {
        $this->MarkForPO = $markForPO;
        return $this;
    }
    /**
     * Get RelatedDocument value
     * @return \StructType\Field|null
     */
    public function getRelatedDocument()
    {
        return $this->RelatedDocument;
    }
    /**
     * Set RelatedDocument value
     * @param \StructType\Field $relatedDocument
     * @return \StructType\SO301000Allocations
     */
    public function setRelatedDocument(\StructType\Field $relatedDocument = null)
    {
        $this->RelatedDocument = $relatedDocument;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SO301000AllocationsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SO301000AllocationsServiceCommands $serviceCommands
     * @return \StructType\SO301000Allocations
     */
    public function setServiceCommands(\StructType\SO301000AllocationsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SO301000Allocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
