<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IN304000DocumentSummary StructType
 * @subpackage Structs
 */
class IN304000DocumentSummary extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ReferenceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Status;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Hold;
    /**
     * The TransferType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TransferType;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Date;
    /**
     * The PostPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PostPeriod;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $WarehouseID;
    /**
     * The ToWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ToWarehouseID;
    /**
     * The ExternalRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExternalRef;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The ControlQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ControlQty;
    /**
     * The TotalQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TotalQty;
    /**
     * The NoteText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The ServiceCommands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IN304000DocumentSummaryServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for IN304000DocumentSummary
     * @uses IN304000DocumentSummary::setDisplayName()
     * @uses IN304000DocumentSummary::setReferenceNbr()
     * @uses IN304000DocumentSummary::setStatus()
     * @uses IN304000DocumentSummary::setHold()
     * @uses IN304000DocumentSummary::setTransferType()
     * @uses IN304000DocumentSummary::setDate()
     * @uses IN304000DocumentSummary::setPostPeriod()
     * @uses IN304000DocumentSummary::setWarehouseID()
     * @uses IN304000DocumentSummary::setToWarehouseID()
     * @uses IN304000DocumentSummary::setExternalRef()
     * @uses IN304000DocumentSummary::setDescription()
     * @uses IN304000DocumentSummary::setControlQty()
     * @uses IN304000DocumentSummary::setTotalQty()
     * @uses IN304000DocumentSummary::setNoteText()
     * @uses IN304000DocumentSummary::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $referenceNbr
     * @param \StructType\Field $status
     * @param \StructType\Field $hold
     * @param \StructType\Field $transferType
     * @param \StructType\Field $date
     * @param \StructType\Field $postPeriod
     * @param \StructType\Field $warehouseID
     * @param \StructType\Field $toWarehouseID
     * @param \StructType\Field $externalRef
     * @param \StructType\Field $description
     * @param \StructType\Field $controlQty
     * @param \StructType\Field $totalQty
     * @param \StructType\Field $noteText
     * @param \StructType\IN304000DocumentSummaryServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $referenceNbr = null, \StructType\Field $status = null, \StructType\Field $hold = null, \StructType\Field $transferType = null, \StructType\Field $date = null, \StructType\Field $postPeriod = null, \StructType\Field $warehouseID = null, \StructType\Field $toWarehouseID = null, \StructType\Field $externalRef = null, \StructType\Field $description = null, \StructType\Field $controlQty = null, \StructType\Field $totalQty = null, \StructType\Field $noteText = null, \StructType\IN304000DocumentSummaryServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setHold($hold)
            ->setTransferType($transferType)
            ->setDate($date)
            ->setPostPeriod($postPeriod)
            ->setWarehouseID($warehouseID)
            ->setToWarehouseID($toWarehouseID)
            ->setExternalRef($externalRef)
            ->setDescription($description)
            ->setControlQty($controlQty)
            ->setTotalQty($totalQty)
            ->setNoteText($noteText)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\IN304000DocumentSummary
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * @return \StructType\Field|null
     */
    public function getReferenceNbr()
    {
        return $this->ReferenceNbr;
    }
    /**
     * Set ReferenceNbr value
     * @param \StructType\Field $referenceNbr
     * @return \StructType\IN304000DocumentSummary
     */
    public function setReferenceNbr(\StructType\Field $referenceNbr = null)
    {
        $this->ReferenceNbr = $referenceNbr;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Field|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Field $status
     * @return \StructType\IN304000DocumentSummary
     */
    public function setStatus(\StructType\Field $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Hold value
     * @return \StructType\Field|null
     */
    public function getHold()
    {
        return $this->Hold;
    }
    /**
     * Set Hold value
     * @param \StructType\Field $hold
     * @return \StructType\IN304000DocumentSummary
     */
    public function setHold(\StructType\Field $hold = null)
    {
        $this->Hold = $hold;
        return $this;
    }
    /**
     * Get TransferType value
     * @return \StructType\Field|null
     */
    public function getTransferType()
    {
        return $this->TransferType;
    }
    /**
     * Set TransferType value
     * @param \StructType\Field $transferType
     * @return \StructType\IN304000DocumentSummary
     */
    public function setTransferType(\StructType\Field $transferType = null)
    {
        $this->TransferType = $transferType;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\Field|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param \StructType\Field $date
     * @return \StructType\IN304000DocumentSummary
     */
    public function setDate(\StructType\Field $date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get PostPeriod value
     * @return \StructType\Field|null
     */
    public function getPostPeriod()
    {
        return $this->PostPeriod;
    }
    /**
     * Set PostPeriod value
     * @param \StructType\Field $postPeriod
     * @return \StructType\IN304000DocumentSummary
     */
    public function setPostPeriod(\StructType\Field $postPeriod = null)
    {
        $this->PostPeriod = $postPeriod;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return \StructType\Field|null
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param \StructType\Field $warehouseID
     * @return \StructType\IN304000DocumentSummary
     */
    public function setWarehouseID(\StructType\Field $warehouseID = null)
    {
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get ToWarehouseID value
     * @return \StructType\Field|null
     */
    public function getToWarehouseID()
    {
        return $this->ToWarehouseID;
    }
    /**
     * Set ToWarehouseID value
     * @param \StructType\Field $toWarehouseID
     * @return \StructType\IN304000DocumentSummary
     */
    public function setToWarehouseID(\StructType\Field $toWarehouseID = null)
    {
        $this->ToWarehouseID = $toWarehouseID;
        return $this;
    }
    /**
     * Get ExternalRef value
     * @return \StructType\Field|null
     */
    public function getExternalRef()
    {
        return $this->ExternalRef;
    }
    /**
     * Set ExternalRef value
     * @param \StructType\Field $externalRef
     * @return \StructType\IN304000DocumentSummary
     */
    public function setExternalRef(\StructType\Field $externalRef = null)
    {
        $this->ExternalRef = $externalRef;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\IN304000DocumentSummary
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ControlQty value
     * @return \StructType\Field|null
     */
    public function getControlQty()
    {
        return $this->ControlQty;
    }
    /**
     * Set ControlQty value
     * @param \StructType\Field $controlQty
     * @return \StructType\IN304000DocumentSummary
     */
    public function setControlQty(\StructType\Field $controlQty = null)
    {
        $this->ControlQty = $controlQty;
        return $this;
    }
    /**
     * Get TotalQty value
     * @return \StructType\Field|null
     */
    public function getTotalQty()
    {
        return $this->TotalQty;
    }
    /**
     * Set TotalQty value
     * @param \StructType\Field $totalQty
     * @return \StructType\IN304000DocumentSummary
     */
    public function setTotalQty(\StructType\Field $totalQty = null)
    {
        $this->TotalQty = $totalQty;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\IN304000DocumentSummary
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\IN304000DocumentSummaryServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\IN304000DocumentSummaryServiceCommands $serviceCommands
     * @return \StructType\IN304000DocumentSummary
     */
    public function setServiceCommands(\StructType\IN304000DocumentSummaryServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IN304000DocumentSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
