<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for POS ServiceType
 * @subpackage Services
 */
class POS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PO301000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO301000SetSchema $parameters
     * @return \StructType\PO301000SetSchemaResponse|bool
     */
    public function PO301000SetSchema(\StructType\PO301000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO301000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO301000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO301000Submit $parameters
     * @return \StructType\PO301000SubmitResponse|bool
     */
    public function PO301000Submit(\StructType\PO301000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO301000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO302000SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO302000SetSchema $parameters
     * @return \StructType\PO302000SetSchemaResponse|bool
     */
    public function PO302000SetSchema(\StructType\PO302000SetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO302000SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO302000Submit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO302000Submit $parameters
     * @return \StructType\PO302000SubmitResponse|bool
     */
    public function PO302000Submit(\StructType\PO302000Submit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO302000Submit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PO301000SetSchemaResponse|\StructType\PO301000SubmitResponse|\StructType\PO302000SetSchemaResponse|\StructType\PO302000SubmitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
