<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for POG ServiceType
 * @subpackage Services
 */
class POG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PO301000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO301000GetProcessStatus $parameters
     * @return \StructType\PO301000GetProcessStatusResponse|bool
     */
    public function PO301000GetProcessStatus(\StructType\PO301000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO301000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO301000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO301000GetSchema $parameters
     * @return \StructType\PO301000GetSchemaResponse|bool
     */
    public function PO301000GetSchema(\StructType\PO301000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO301000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO302000GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO302000GetProcessStatus $parameters
     * @return \StructType\PO302000GetProcessStatusResponse|bool
     */
    public function PO302000GetProcessStatus(\StructType\PO302000GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO302000GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PO302000GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PO302000GetSchema $parameters
     * @return \StructType\PO302000GetSchemaResponse|bool
     */
    public function PO302000GetSchema(\StructType\PO302000GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PO302000GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PO301000GetProcessStatusResponse|\StructType\PO301000GetSchemaResponse|\StructType\PO302000GetProcessStatusResponse|\StructType\PO302000GetSchemaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
