<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for INE ServiceType
 * @subpackage Services
 */
class INE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IN202500Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN202500Export $parameters
     * @return \StructType\IN202500ExportResponse|bool
     */
    public function IN202500Export(\StructType\IN202500Export $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN202500Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IN304000Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IN304000Export $parameters
     * @return \StructType\IN304000ExportResponse|bool
     */
    public function IN304000Export(\StructType\IN304000Export $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IN304000Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IN202500ExportResponse|\StructType\IN304000ExportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
