<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ARI ServiceType
 * @subpackage Services
 */
class ARI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AR302000Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR302000Import $parameters
     * @return \StructType\AR302000ImportResponse|bool
     */
    public function AR302000Import(\StructType\AR302000Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR302000Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR303000Import
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR303000Import $parameters
     * @return \StructType\AR303000ImportResponse|bool
     */
    public function AR303000Import(\StructType\AR303000Import $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR303000Import($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AR302000ImportResponse|\StructType\AR303000ImportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
