<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ARE ServiceType
 * @subpackage Services
 */
class ARE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AR302000Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR302000Export $parameters
     * @return \StructType\AR302000ExportResponse|bool
     */
    public function AR302000Export(\StructType\AR302000Export $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR302000Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AR303000Export
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AR303000Export $parameters
     * @return \StructType\AR303000ExportResponse|bool
     */
    public function AR303000Export(\StructType\AR303000Export $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AR303000Export($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AR302000ExportResponse|\StructType\AR303000ExportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
