<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ProcessResult' => '\\StructType\\ProcessResult',
            'GetScenario' => '\\StructType\\GetScenario',
            'GetScenarioResponse' => '\\StructType\\GetScenarioResponse',
            'ArrayOfCommand' => '\\ArrayType\\ArrayOfCommand',
            'Command' => '\\StructType\\Command',
            'ElementDescriptor' => '\\StructType\\ElementDescriptor',
            'ArrayOfString' => '\\ArrayType\\ArrayOfString',
            'EveryValue' => '\\StructType\\EveryValue',
            'Key' => '\\StructType\\Key',
            'Action' => '\\StructType\\Action',
            'Field' => '\\StructType\\Field',
            'Value' => '\\StructType\\Value',
            'Answer' => '\\StructType\\Answer',
            'RowNumber' => '\\StructType\\RowNumber',
            'NewRow' => '\\StructType\\NewRow',
            'DeleteRow' => '\\StructType\\DeleteRow',
            'Parameter' => '\\StructType\\Parameter',
            'Attachment' => '\\StructType\\Attachment',
            'ArrayOfFilter' => '\\ArrayType\\ArrayOfFilter',
            'Filter' => '\\StructType\\Filter',
            'ArrayOfArrayOfString' => '\\ArrayType\\ArrayOfArrayOfString',
            'Login' => '\\StructType\\Login',
            'LoginResult' => '\\StructType\\LoginResult',
            'LoginResponse' => '\\StructType\\LoginResponse',
            'Logout' => '\\StructType\\Logout',
            'LogoutResponse' => '\\StructType\\LogoutResponse',
            'SetBusinessDate' => '\\StructType\\SetBusinessDate',
            'SetBusinessDateResponse' => '\\StructType\\SetBusinessDateResponse',
            'SetLocaleName' => '\\StructType\\SetLocaleName',
            'SetLocaleNameResponse' => '\\StructType\\SetLocaleNameResponse',
            'SetSchemaMode' => '\\StructType\\SetSchemaMode',
            'SetSchemaModeResponse' => '\\StructType\\SetSchemaModeResponse',
            'AR302000Content' => '\\StructType\\AR302000Content',
            'AR302000Actions' => '\\StructType\\AR302000Actions',
            'AR302000PaymentSummary' => '\\StructType\\AR302000PaymentSummary',
            'AR302000PaymentSummaryServiceCommands' => '\\StructType\\AR302000PaymentSummaryServiceCommands',
            'AR302000FinancialDetailsLinkToGL' => '\\StructType\\AR302000FinancialDetailsLinkToGL',
            'AR302000FinancialDetailsLinkToGLServiceCommands' => '\\StructType\\AR302000FinancialDetailsLinkToGLServiceCommands',
            'AR302000FinancialDetailsPaymentInformation' => '\\StructType\\AR302000FinancialDetailsPaymentInformation',
            'AR302000FinancialDetailsPaymentInformationServiceCommands' => '\\StructType\\AR302000FinancialDetailsPaymentInformationServiceCommands',
            'AR302000DocumentsToApply' => '\\StructType\\AR302000DocumentsToApply',
            'AR302000DocumentsToApplyServiceCommands' => '\\StructType\\AR302000DocumentsToApplyServiceCommands',
            'AR302000ApplicationHistory' => '\\StructType\\AR302000ApplicationHistory',
            'AR302000ApplicationHistoryServiceCommands' => '\\StructType\\AR302000ApplicationHistoryServiceCommands',
            'AR302000OrdersToApply' => '\\StructType\\AR302000OrdersToApply',
            'AR302000OrdersToApplyServiceCommands' => '\\StructType\\AR302000OrdersToApplyServiceCommands',
            'AR302000PaymentSummaryRateSelection' => '\\StructType\\AR302000PaymentSummaryRateSelection',
            'AR302000PaymentSummaryRateSelectionServiceCommands' => '\\StructType\\AR302000PaymentSummaryRateSelectionServiceCommands',
            'AR302000PaymentSummaryRateSelectionCurrencyUnitEquivalents' => '\\StructType\\AR302000PaymentSummaryRateSelectionCurrencyUnitEquivalents',
            'AR302000PaymentSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\AR302000PaymentSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands',
            'AR302000CreditCardProcessingInfo' => '\\StructType\\AR302000CreditCardProcessingInfo',
            'AR302000CreditCardProcessingInfoServiceCommands' => '\\StructType\\AR302000CreditCardProcessingInfoServiceCommands',
            'AR302000FinanceCharges' => '\\StructType\\AR302000FinanceCharges',
            'AR302000FinanceChargesServiceCommands' => '\\StructType\\AR302000FinanceChargesServiceCommands',
            'AR302000RecordCCPaymentCCPaymentData' => '\\StructType\\AR302000RecordCCPaymentCCPaymentData',
            'AR302000RecordCCPaymentCCPaymentDataServiceCommands' => '\\StructType\\AR302000RecordCCPaymentCCPaymentDataServiceCommands',
            'AR302000CCPaymentWithExternalAuthorizationCCPaymentData' => '\\StructType\\AR302000CCPaymentWithExternalAuthorizationCCPaymentData',
            'AR302000CCPaymentWithExternalAuthorizationCCPaymentDataServiceCommands' => '\\StructType\\AR302000CCPaymentWithExternalAuthorizationCCPaymentDataServiceCommands',
            'AR302000LoadOptions' => '\\StructType\\AR302000LoadOptions',
            'AR302000LoadOptionsServiceCommands' => '\\StructType\\AR302000LoadOptionsServiceCommands',
            'AR302000FinancialDetailsVoucherDetails' => '\\StructType\\AR302000FinancialDetailsVoucherDetails',
            'AR302000FinancialDetailsVoucherDetailsServiceCommands' => '\\StructType\\AR302000FinancialDetailsVoucherDetailsServiceCommands',
            'AR302000PrimaryKey' => '\\StructType\\AR302000PrimaryKey',
            'AR302000Clear' => '\\StructType\\AR302000Clear',
            'AR302000ClearResponse' => '\\StructType\\AR302000ClearResponse',
            'AR302000GetProcessStatus' => '\\StructType\\AR302000GetProcessStatus',
            'AR302000GetProcessStatusResponse' => '\\StructType\\AR302000GetProcessStatusResponse',
            'AR302000GetSchema' => '\\StructType\\AR302000GetSchema',
            'AR302000GetSchemaResponse' => '\\StructType\\AR302000GetSchemaResponse',
            'AR302000SetSchema' => '\\StructType\\AR302000SetSchema',
            'AR302000SetSchemaResponse' => '\\StructType\\AR302000SetSchemaResponse',
            'AR302000Export' => '\\StructType\\AR302000Export',
            'AR302000ExportResponse' => '\\StructType\\AR302000ExportResponse',
            'AR302000Import' => '\\StructType\\AR302000Import',
            'AR302000ImportResponse' => '\\StructType\\AR302000ImportResponse',
            'AR302000ImportResult' => '\\StructType\\AR302000ImportResult',
            'AR302000ArrayOfImportResult' => '\\ArrayType\\AR302000ArrayOfImportResult',
            'AR302000Submit' => '\\StructType\\AR302000Submit',
            'AR302000ArrayOfContent' => '\\ArrayType\\AR302000ArrayOfContent',
            'AR302000SubmitResponse' => '\\StructType\\AR302000SubmitResponse',
            'AR303000Content' => '\\StructType\\AR303000Content',
            'AR303000Actions' => '\\StructType\\AR303000Actions',
            'AR303000CustomerSummary' => '\\StructType\\AR303000CustomerSummary',
            'AR303000CustomerSummaryServiceCommands' => '\\StructType\\AR303000CustomerSummaryServiceCommands',
            'AR303000GeneralInfo' => '\\StructType\\AR303000GeneralInfo',
            'AR303000GeneralInfoServiceCommands' => '\\StructType\\AR303000GeneralInfoServiceCommands',
            'AR303000GeneralInfoFinancialSettings' => '\\StructType\\AR303000GeneralInfoFinancialSettings',
            'AR303000GeneralInfoFinancialSettingsServiceCommands' => '\\StructType\\AR303000GeneralInfoFinancialSettingsServiceCommands',
            'AR303000GeneralInfoCreditVerificationRulesCreditVerification' => '\\StructType\\AR303000GeneralInfoCreditVerificationRulesCreditVerification',
            'AR303000GeneralInfoCreditVerificationRulesCreditVerificationServiceCommands' => '\\StructType\\AR303000GeneralInfoCreditVerificationRulesCreditVerificationServiceCommands',
            'AR303000BillingSettingsBillToContactSameAsMain' => '\\StructType\\AR303000BillingSettingsBillToContactSameAsMain',
            'AR303000BillingSettingsBillToContactSameAsMainServiceCommands' => '\\StructType\\AR303000BillingSettingsBillToContactSameAsMainServiceCommands',
            'AR303000BillingSettingsBillToAddressSameAsMain' => '\\StructType\\AR303000BillingSettingsBillToAddressSameAsMain',
            'AR303000BillingSettingsBillToAddressSameAsMainServiceCommands' => '\\StructType\\AR303000BillingSettingsBillToAddressSameAsMainServiceCommands',
            'AR303000BillingSettingsParentInfo' => '\\StructType\\AR303000BillingSettingsParentInfo',
            'AR303000BillingSettingsParentInfoServiceCommands' => '\\StructType\\AR303000BillingSettingsParentInfoServiceCommands',
            'AR303000BillingSettingsPrintAndEmailSettings' => '\\StructType\\AR303000BillingSettingsPrintAndEmailSettings',
            'AR303000BillingSettingsPrintAndEmailSettingsServiceCommands' => '\\StructType\\AR303000BillingSettingsPrintAndEmailSettingsServiceCommands',
            'AR303000BillingSettingsDefaultPaymentMethodDefaultPaymentMethod' => '\\StructType\\AR303000BillingSettingsDefaultPaymentMethodDefaultPaymentMethod',
            'AR303000BillingSettingsDefaultPaymentMethodDefaultPaymentMethodServiceCommands' => '\\StructType\\AR303000BillingSettingsDefaultPaymentMethodDefaultPaymentMethodServiceCommands',
            'AR303000GLAccountsCashDiscountAccount' => '\\StructType\\AR303000GLAccountsCashDiscountAccount',
            'AR303000GLAccountsCashDiscountAccountServiceCommands' => '\\StructType\\AR303000GLAccountsCashDiscountAccountServiceCommands',
            'AR303000GeneralInfoMainAddress' => '\\StructType\\AR303000GeneralInfoMainAddress',
            'AR303000GeneralInfoMainAddressServiceCommands' => '\\StructType\\AR303000GeneralInfoMainAddressServiceCommands',
            'AR303000BillingSettingsBillToAddress' => '\\StructType\\AR303000BillingSettingsBillToAddress',
            'AR303000BillingSettingsBillToAddressServiceCommands' => '\\StructType\\AR303000BillingSettingsBillToAddressServiceCommands',
            'AR303000GeneralInfoMainContact' => '\\StructType\\AR303000GeneralInfoMainContact',
            'AR303000GeneralInfoMainContactServiceCommands' => '\\StructType\\AR303000GeneralInfoMainContactServiceCommands',
            'AR303000DeliverySettingsShippingContact' => '\\StructType\\AR303000DeliverySettingsShippingContact',
            'AR303000DeliverySettingsShippingContactServiceCommands' => '\\StructType\\AR303000DeliverySettingsShippingContactServiceCommands',
            'AR303000BillingSettingsBillToContact' => '\\StructType\\AR303000BillingSettingsBillToContact',
            'AR303000BillingSettingsBillToContactServiceCommands' => '\\StructType\\AR303000BillingSettingsBillToContactServiceCommands',
            'AR303000Locations' => '\\StructType\\AR303000Locations',
            'AR303000LocationsServiceCommands' => '\\StructType\\AR303000LocationsServiceCommands',
            'AR303000DeliverySettingsShippingContactSameAsMain' => '\\StructType\\AR303000DeliverySettingsShippingContactSameAsMain',
            'AR303000DeliverySettingsShippingContactSameAsMainServiceCommands' => '\\StructType\\AR303000DeliverySettingsShippingContactSameAsMainServiceCommands',
            'AR303000DeliverySettingsShippingAddress' => '\\StructType\\AR303000DeliverySettingsShippingAddress',
            'AR303000DeliverySettingsShippingAddressServiceCommands' => '\\StructType\\AR303000DeliverySettingsShippingAddressServiceCommands',
            'AR303000DeliverySettingsDefaultLocationSettings' => '\\StructType\\AR303000DeliverySettingsDefaultLocationSettings',
            'AR303000DeliverySettingsDefaultLocationSettingsServiceCommands' => '\\StructType\\AR303000DeliverySettingsDefaultLocationSettingsServiceCommands',
            'AR303000DeliverySettingsShippingInstructions' => '\\StructType\\AR303000DeliverySettingsShippingInstructions',
            'AR303000DeliverySettingsShippingInstructionsServiceCommands' => '\\StructType\\AR303000DeliverySettingsShippingInstructionsServiceCommands',
            'AR303000GLAccounts' => '\\StructType\\AR303000GLAccounts',
            'AR303000GLAccountsServiceCommands' => '\\StructType\\AR303000GLAccountsServiceCommands',
            'AR303000Contacts' => '\\StructType\\AR303000Contacts',
            'AR303000ContactsServiceCommands' => '\\StructType\\AR303000ContactsServiceCommands',
            'AR303000Salespersons' => '\\StructType\\AR303000Salespersons',
            'AR303000SalespersonsServiceCommands' => '\\StructType\\AR303000SalespersonsServiceCommands',
            'AR303000CustomerSummaryBalance' => '\\StructType\\AR303000CustomerSummaryBalance',
            'AR303000CustomerSummaryBalanceServiceCommands' => '\\StructType\\AR303000CustomerSummaryBalanceServiceCommands',
            'AR303000GeneralInfoCreditVerificationRules' => '\\StructType\\AR303000GeneralInfoCreditVerificationRules',
            'AR303000GeneralInfoCreditVerificationRulesServiceCommands' => '\\StructType\\AR303000GeneralInfoCreditVerificationRulesServiceCommands',
            'AR303000DeliverySettingsShippingInstructionsCarrierAccounts' => '\\StructType\\AR303000DeliverySettingsShippingInstructionsCarrierAccounts',
            'AR303000DeliverySettingsShippingInstructionsCarrierAccountsServiceCommands' => '\\StructType\\AR303000DeliverySettingsShippingInstructionsCarrierAccountsServiceCommands',
            'AR303000BillingSettingsDefaultPaymentMethod' => '\\StructType\\AR303000BillingSettingsDefaultPaymentMethod',
            'AR303000BillingSettingsDefaultPaymentMethodServiceCommands' => '\\StructType\\AR303000BillingSettingsDefaultPaymentMethodServiceCommands',
            'AR303000PaymentMethods' => '\\StructType\\AR303000PaymentMethods',
            'AR303000PaymentMethodsServiceCommands' => '\\StructType\\AR303000PaymentMethodsServiceCommands',
            'AR303000Attributes' => '\\StructType\\AR303000Attributes',
            'AR303000AttributesServiceCommands' => '\\StructType\\AR303000AttributesServiceCommands',
            'AR303000Activities' => '\\StructType\\AR303000Activities',
            'AR303000ActivitiesServiceCommands' => '\\StructType\\AR303000ActivitiesServiceCommands',
            'AR303000BillingSettingsDefaultPaymentMethodPaymentMethodDetails' => '\\StructType\\AR303000BillingSettingsDefaultPaymentMethodPaymentMethodDetails',
            'AR303000BillingSettingsDefaultPaymentMethodPaymentMethodDetailsServiceCommands' => '\\StructType\\AR303000BillingSettingsDefaultPaymentMethodPaymentMethodDetailsServiceCommands',
            'AR303000MailingSettingsMailings' => '\\StructType\\AR303000MailingSettingsMailings',
            'AR303000MailingSettingsMailingsServiceCommands' => '\\StructType\\AR303000MailingSettingsMailingsServiceCommands',
            'AR303000MailingSettingsRecipients' => '\\StructType\\AR303000MailingSettingsRecipients',
            'AR303000MailingSettingsRecipientsServiceCommands' => '\\StructType\\AR303000MailingSettingsRecipientsServiceCommands',
            'AR303000ChildAccounts' => '\\StructType\\AR303000ChildAccounts',
            'AR303000ChildAccountsServiceCommands' => '\\StructType\\AR303000ChildAccountsServiceCommands',
            'AR303000SpecifyNewID' => '\\StructType\\AR303000SpecifyNewID',
            'AR303000SpecifyNewIDServiceCommands' => '\\StructType\\AR303000SpecifyNewIDServiceCommands',
            'AR303000PrimaryKey' => '\\StructType\\AR303000PrimaryKey',
            'AR303000Clear' => '\\StructType\\AR303000Clear',
            'AR303000ClearResponse' => '\\StructType\\AR303000ClearResponse',
            'AR303000GetProcessStatus' => '\\StructType\\AR303000GetProcessStatus',
            'AR303000GetProcessStatusResponse' => '\\StructType\\AR303000GetProcessStatusResponse',
            'AR303000GetSchema' => '\\StructType\\AR303000GetSchema',
            'AR303000GetSchemaResponse' => '\\StructType\\AR303000GetSchemaResponse',
            'AR303000SetSchema' => '\\StructType\\AR303000SetSchema',
            'AR303000SetSchemaResponse' => '\\StructType\\AR303000SetSchemaResponse',
            'AR303000Export' => '\\StructType\\AR303000Export',
            'AR303000ExportResponse' => '\\StructType\\AR303000ExportResponse',
            'AR303000Import' => '\\StructType\\AR303000Import',
            'AR303000ImportResponse' => '\\StructType\\AR303000ImportResponse',
            'AR303000ImportResult' => '\\StructType\\AR303000ImportResult',
            'AR303000ArrayOfImportResult' => '\\ArrayType\\AR303000ArrayOfImportResult',
            'AR303000Submit' => '\\StructType\\AR303000Submit',
            'AR303000ArrayOfContent' => '\\ArrayType\\AR303000ArrayOfContent',
            'AR303000SubmitResponse' => '\\StructType\\AR303000SubmitResponse',
            'CA304000Content' => '\\StructType\\CA304000Content',
            'CA304000Actions' => '\\StructType\\CA304000Actions',
            'CA304000TransactionSummary' => '\\StructType\\CA304000TransactionSummary',
            'CA304000TransactionSummaryServiceCommands' => '\\StructType\\CA304000TransactionSummaryServiceCommands',
            'CA304000FinancialDetailsLinkToGL' => '\\StructType\\CA304000FinancialDetailsLinkToGL',
            'CA304000FinancialDetailsLinkToGLServiceCommands' => '\\StructType\\CA304000FinancialDetailsLinkToGLServiceCommands',
            'CA304000FinancialDetailsTaxSettings' => '\\StructType\\CA304000FinancialDetailsTaxSettings',
            'CA304000FinancialDetailsTaxSettingsServiceCommands' => '\\StructType\\CA304000FinancialDetailsTaxSettingsServiceCommands',
            'CA304000TransactionDetails' => '\\StructType\\CA304000TransactionDetails',
            'CA304000TransactionDetailsServiceCommands' => '\\StructType\\CA304000TransactionDetailsServiceCommands',
            'CA304000TaxDetails' => '\\StructType\\CA304000TaxDetails',
            'CA304000TaxDetailsServiceCommands' => '\\StructType\\CA304000TaxDetailsServiceCommands',
            'CA304000ApprovalDetails' => '\\StructType\\CA304000ApprovalDetails',
            'CA304000ApprovalDetailsServiceCommands' => '\\StructType\\CA304000ApprovalDetailsServiceCommands',
            'CA304000TransactionSummaryRateSelection' => '\\StructType\\CA304000TransactionSummaryRateSelection',
            'CA304000TransactionSummaryRateSelectionServiceCommands' => '\\StructType\\CA304000TransactionSummaryRateSelectionServiceCommands',
            'CA304000TransactionSummaryRateSelectionCurrencyUnitEquivalents' => '\\StructType\\CA304000TransactionSummaryRateSelectionCurrencyUnitEquivalents',
            'CA304000TransactionSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\CA304000TransactionSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands',
            'CA304000FinancialDetailsVoucherDetails' => '\\StructType\\CA304000FinancialDetailsVoucherDetails',
            'CA304000FinancialDetailsVoucherDetailsServiceCommands' => '\\StructType\\CA304000FinancialDetailsVoucherDetailsServiceCommands',
            'CA304000PrimaryKey' => '\\StructType\\CA304000PrimaryKey',
            'CA304000Clear' => '\\StructType\\CA304000Clear',
            'CA304000ClearResponse' => '\\StructType\\CA304000ClearResponse',
            'CA304000GetProcessStatus' => '\\StructType\\CA304000GetProcessStatus',
            'CA304000GetProcessStatusResponse' => '\\StructType\\CA304000GetProcessStatusResponse',
            'CA304000GetSchema' => '\\StructType\\CA304000GetSchema',
            'CA304000GetSchemaResponse' => '\\StructType\\CA304000GetSchemaResponse',
            'CA304000SetSchema' => '\\StructType\\CA304000SetSchema',
            'CA304000SetSchemaResponse' => '\\StructType\\CA304000SetSchemaResponse',
            'CA304000Export' => '\\StructType\\CA304000Export',
            'CA304000ExportResponse' => '\\StructType\\CA304000ExportResponse',
            'CA304000Import' => '\\StructType\\CA304000Import',
            'CA304000ImportResponse' => '\\StructType\\CA304000ImportResponse',
            'CA304000ImportResult' => '\\StructType\\CA304000ImportResult',
            'CA304000ArrayOfImportResult' => '\\ArrayType\\CA304000ArrayOfImportResult',
            'CA304000Submit' => '\\StructType\\CA304000Submit',
            'CA304000ArrayOfContent' => '\\ArrayType\\CA304000ArrayOfContent',
            'CA304000SubmitResponse' => '\\StructType\\CA304000SubmitResponse',
            'GL301000Content' => '\\StructType\\GL301000Content',
            'GL301000Actions' => '\\StructType\\GL301000Actions',
            'GL301000BatchSummary' => '\\StructType\\GL301000BatchSummary',
            'GL301000BatchSummaryServiceCommands' => '\\StructType\\GL301000BatchSummaryServiceCommands',
            'GL301000BatchSummaryRateSelection' => '\\StructType\\GL301000BatchSummaryRateSelection',
            'GL301000BatchSummaryRateSelectionServiceCommands' => '\\StructType\\GL301000BatchSummaryRateSelectionServiceCommands',
            'GL301000BatchSummaryRateSelectionCurrencyUnitEquivalents' => '\\StructType\\GL301000BatchSummaryRateSelectionCurrencyUnitEquivalents',
            'GL301000BatchSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\GL301000BatchSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands',
            'GL301000TransactionDetails' => '\\StructType\\GL301000TransactionDetails',
            'GL301000TransactionDetailsServiceCommands' => '\\StructType\\GL301000TransactionDetailsServiceCommands',
            'GL301000BatchSummaryVoucherBatchNbr' => '\\StructType\\GL301000BatchSummaryVoucherBatchNbr',
            'GL301000BatchSummaryVoucherBatchNbrServiceCommands' => '\\StructType\\GL301000BatchSummaryVoucherBatchNbrServiceCommands',
            'GL301000PrimaryKey' => '\\StructType\\GL301000PrimaryKey',
            'GL301000Clear' => '\\StructType\\GL301000Clear',
            'GL301000ClearResponse' => '\\StructType\\GL301000ClearResponse',
            'GL301000GetProcessStatus' => '\\StructType\\GL301000GetProcessStatus',
            'GL301000GetProcessStatusResponse' => '\\StructType\\GL301000GetProcessStatusResponse',
            'GL301000GetSchema' => '\\StructType\\GL301000GetSchema',
            'GL301000GetSchemaResponse' => '\\StructType\\GL301000GetSchemaResponse',
            'GL301000SetSchema' => '\\StructType\\GL301000SetSchema',
            'GL301000SetSchemaResponse' => '\\StructType\\GL301000SetSchemaResponse',
            'GL301000Export' => '\\StructType\\GL301000Export',
            'GL301000ExportResponse' => '\\StructType\\GL301000ExportResponse',
            'GL301000Import' => '\\StructType\\GL301000Import',
            'GL301000ImportResponse' => '\\StructType\\GL301000ImportResponse',
            'GL301000ImportResult' => '\\StructType\\GL301000ImportResult',
            'GL301000ArrayOfImportResult' => '\\ArrayType\\GL301000ArrayOfImportResult',
            'GL301000Submit' => '\\StructType\\GL301000Submit',
            'GL301000ArrayOfContent' => '\\ArrayType\\GL301000ArrayOfContent',
            'GL301000SubmitResponse' => '\\StructType\\GL301000SubmitResponse',
            'IN202500Content' => '\\StructType\\IN202500Content',
            'IN202500Actions' => '\\StructType\\IN202500Actions',
            'IN202500StockItemSummary' => '\\StructType\\IN202500StockItemSummary',
            'IN202500StockItemSummaryServiceCommands' => '\\StructType\\IN202500StockItemSummaryServiceCommands',
            'IN202500GeneralSettingsItemDefaults' => '\\StructType\\IN202500GeneralSettingsItemDefaults',
            'IN202500GeneralSettingsItemDefaultsServiceCommands' => '\\StructType\\IN202500GeneralSettingsItemDefaultsServiceCommands',
            'IN202500GeneralSettingsWarehouseDefaults' => '\\StructType\\IN202500GeneralSettingsWarehouseDefaults',
            'IN202500GeneralSettingsWarehouseDefaultsServiceCommands' => '\\StructType\\IN202500GeneralSettingsWarehouseDefaultsServiceCommands',
            'IN202500GeneralSettingsUnitOfMeasureBaseUnit' => '\\StructType\\IN202500GeneralSettingsUnitOfMeasureBaseUnit',
            'IN202500GeneralSettingsUnitOfMeasureBaseUnitServiceCommands' => '\\StructType\\IN202500GeneralSettingsUnitOfMeasureBaseUnitServiceCommands',
            'IN202500GeneralSettingsPhysicalInventory' => '\\StructType\\IN202500GeneralSettingsPhysicalInventory',
            'IN202500GeneralSettingsPhysicalInventoryServiceCommands' => '\\StructType\\IN202500GeneralSettingsPhysicalInventoryServiceCommands',
            'IN202500PriceCostInfoPriceManagement' => '\\StructType\\IN202500PriceCostInfoPriceManagement',
            'IN202500PriceCostInfoPriceManagementServiceCommands' => '\\StructType\\IN202500PriceCostInfoPriceManagementServiceCommands',
            'IN202500PriceCostInfoStandardCost' => '\\StructType\\IN202500PriceCostInfoStandardCost',
            'IN202500PriceCostInfoStandardCostServiceCommands' => '\\StructType\\IN202500PriceCostInfoStandardCostServiceCommands',
            'IN202500Ecommerce' => '\\StructType\\IN202500Ecommerce',
            'IN202500EcommerceServiceCommands' => '\\StructType\\IN202500EcommerceServiceCommands',
            'IN202500Attributes' => '\\StructType\\IN202500Attributes',
            'IN202500AttributesServiceCommands' => '\\StructType\\IN202500AttributesServiceCommands',
            'IN202500PackagingDimensions' => '\\StructType\\IN202500PackagingDimensions',
            'IN202500PackagingDimensionsServiceCommands' => '\\StructType\\IN202500PackagingDimensionsServiceCommands',
            'IN202500PackagingAutomaticPackaging' => '\\StructType\\IN202500PackagingAutomaticPackaging',
            'IN202500PackagingAutomaticPackagingServiceCommands' => '\\StructType\\IN202500PackagingAutomaticPackagingServiceCommands',
            'IN202500GLAccounts' => '\\StructType\\IN202500GLAccounts',
            'IN202500GLAccountsServiceCommands' => '\\StructType\\IN202500GLAccountsServiceCommands',
            'IN202500Description' => '\\StructType\\IN202500Description',
            'IN202500DescriptionServiceCommands' => '\\StructType\\IN202500DescriptionServiceCommands',
            'IN202500DeferralSettingsRules' => '\\StructType\\IN202500DeferralSettingsRules',
            'IN202500DeferralSettingsRulesServiceCommands' => '\\StructType\\IN202500DeferralSettingsRulesServiceCommands',
            'IN202500Subitems' => '\\StructType\\IN202500Subitems',
            'IN202500SubitemsServiceCommands' => '\\StructType\\IN202500SubitemsServiceCommands',
            'IN202500PriceCostInfoCostStatistics' => '\\StructType\\IN202500PriceCostInfoCostStatistics',
            'IN202500PriceCostInfoCostStatisticsServiceCommands' => '\\StructType\\IN202500PriceCostInfoCostStatisticsServiceCommands',
            'IN202500GeneralSettingsUnitOfMeasure' => '\\StructType\\IN202500GeneralSettingsUnitOfMeasure',
            'IN202500GeneralSettingsUnitOfMeasureServiceCommands' => '\\StructType\\IN202500GeneralSettingsUnitOfMeasureServiceCommands',
            'IN202500WarehouseDetails' => '\\StructType\\IN202500WarehouseDetails',
            'IN202500WarehouseDetailsServiceCommands' => '\\StructType\\IN202500WarehouseDetailsServiceCommands',
            'IN202500CrossReference' => '\\StructType\\IN202500CrossReference',
            'IN202500CrossReferenceServiceCommands' => '\\StructType\\IN202500CrossReferenceServiceCommands',
            'IN202500ReplenishmentInfoSubitemReplenishmentParameters' => '\\StructType\\IN202500ReplenishmentInfoSubitemReplenishmentParameters',
            'IN202500ReplenishmentInfoSubitemReplenishmentParametersServiceCommands' => '\\StructType\\IN202500ReplenishmentInfoSubitemReplenishmentParametersServiceCommands',
            'IN202500VendorDetails' => '\\StructType\\IN202500VendorDetails',
            'IN202500VendorDetailsServiceCommands' => '\\StructType\\IN202500VendorDetailsServiceCommands',
            'IN202500PackagingAutomaticPackagingBoxes' => '\\StructType\\IN202500PackagingAutomaticPackagingBoxes',
            'IN202500PackagingAutomaticPackagingBoxesServiceCommands' => '\\StructType\\IN202500PackagingAutomaticPackagingBoxesServiceCommands',
            'IN202500AttributesAttributes' => '\\StructType\\IN202500AttributesAttributes',
            'IN202500AttributesAttributesServiceCommands' => '\\StructType\\IN202500AttributesAttributesServiceCommands',
            'IN202500AttributesSalesCategories' => '\\StructType\\IN202500AttributesSalesCategories',
            'IN202500AttributesSalesCategoriesServiceCommands' => '\\StructType\\IN202500AttributesSalesCategoriesServiceCommands',
            'IN202500EcommerceCrossSells' => '\\StructType\\IN202500EcommerceCrossSells',
            'IN202500EcommerceCrossSellsServiceCommands' => '\\StructType\\IN202500EcommerceCrossSellsServiceCommands',
            'IN202500EcommerceUpSells' => '\\StructType\\IN202500EcommerceUpSells',
            'IN202500EcommerceUpSellsServiceCommands' => '\\StructType\\IN202500EcommerceUpSellsServiceCommands',
            'IN202500SpecifyNewID' => '\\StructType\\IN202500SpecifyNewID',
            'IN202500SpecifyNewIDServiceCommands' => '\\StructType\\IN202500SpecifyNewIDServiceCommands',
            'IN202500PrimaryKey' => '\\StructType\\IN202500PrimaryKey',
            'IN202500Clear' => '\\StructType\\IN202500Clear',
            'IN202500ClearResponse' => '\\StructType\\IN202500ClearResponse',
            'IN202500GetProcessStatus' => '\\StructType\\IN202500GetProcessStatus',
            'IN202500GetProcessStatusResponse' => '\\StructType\\IN202500GetProcessStatusResponse',
            'IN202500GetSchema' => '\\StructType\\IN202500GetSchema',
            'IN202500GetSchemaResponse' => '\\StructType\\IN202500GetSchemaResponse',
            'IN202500SetSchema' => '\\StructType\\IN202500SetSchema',
            'IN202500SetSchemaResponse' => '\\StructType\\IN202500SetSchemaResponse',
            'IN202500Export' => '\\StructType\\IN202500Export',
            'IN202500ExportResponse' => '\\StructType\\IN202500ExportResponse',
            'IN202500Import' => '\\StructType\\IN202500Import',
            'IN202500ImportResponse' => '\\StructType\\IN202500ImportResponse',
            'IN202500ImportResult' => '\\StructType\\IN202500ImportResult',
            'IN202500ArrayOfImportResult' => '\\ArrayType\\IN202500ArrayOfImportResult',
            'IN202500Submit' => '\\StructType\\IN202500Submit',
            'IN202500ArrayOfContent' => '\\ArrayType\\IN202500ArrayOfContent',
            'IN202500SubmitResponse' => '\\StructType\\IN202500SubmitResponse',
            'IN304000Content' => '\\StructType\\IN304000Content',
            'IN304000Actions' => '\\StructType\\IN304000Actions',
            'IN304000DocumentSummary' => '\\StructType\\IN304000DocumentSummary',
            'IN304000DocumentSummaryServiceCommands' => '\\StructType\\IN304000DocumentSummaryServiceCommands',
            'IN304000FinancialDetails' => '\\StructType\\IN304000FinancialDetails',
            'IN304000FinancialDetailsServiceCommands' => '\\StructType\\IN304000FinancialDetailsServiceCommands',
            'IN304000TransactionDetails' => '\\StructType\\IN304000TransactionDetails',
            'IN304000TransactionDetailsServiceCommands' => '\\StructType\\IN304000TransactionDetailsServiceCommands',
            'IN304000Allocations' => '\\StructType\\IN304000Allocations',
            'IN304000AllocationsServiceCommands' => '\\StructType\\IN304000AllocationsServiceCommands',
            'IN304000InventoryLookupInventory' => '\\StructType\\IN304000InventoryLookupInventory',
            'IN304000InventoryLookupInventoryServiceCommands' => '\\StructType\\IN304000InventoryLookupInventoryServiceCommands',
            'IN304000InventoryLookup' => '\\StructType\\IN304000InventoryLookup',
            'IN304000InventoryLookupServiceCommands' => '\\StructType\\IN304000InventoryLookupServiceCommands',
            'IN304000AllocationsUnassignedQty' => '\\StructType\\IN304000AllocationsUnassignedQty',
            'IN304000AllocationsUnassignedQtyServiceCommands' => '\\StructType\\IN304000AllocationsUnassignedQtyServiceCommands',
            'IN304000PrimaryKey' => '\\StructType\\IN304000PrimaryKey',
            'IN304000Clear' => '\\StructType\\IN304000Clear',
            'IN304000ClearResponse' => '\\StructType\\IN304000ClearResponse',
            'IN304000GetProcessStatus' => '\\StructType\\IN304000GetProcessStatus',
            'IN304000GetProcessStatusResponse' => '\\StructType\\IN304000GetProcessStatusResponse',
            'IN304000GetSchema' => '\\StructType\\IN304000GetSchema',
            'IN304000GetSchemaResponse' => '\\StructType\\IN304000GetSchemaResponse',
            'IN304000SetSchema' => '\\StructType\\IN304000SetSchema',
            'IN304000SetSchemaResponse' => '\\StructType\\IN304000SetSchemaResponse',
            'IN304000Export' => '\\StructType\\IN304000Export',
            'IN304000ExportResponse' => '\\StructType\\IN304000ExportResponse',
            'IN304000Import' => '\\StructType\\IN304000Import',
            'IN304000ImportResponse' => '\\StructType\\IN304000ImportResponse',
            'IN304000ImportResult' => '\\StructType\\IN304000ImportResult',
            'IN304000ArrayOfImportResult' => '\\ArrayType\\IN304000ArrayOfImportResult',
            'IN304000Submit' => '\\StructType\\IN304000Submit',
            'IN304000ArrayOfContent' => '\\ArrayType\\IN304000ArrayOfContent',
            'IN304000SubmitResponse' => '\\StructType\\IN304000SubmitResponse',
            'PO301000Content' => '\\StructType\\PO301000Content',
            'PO301000Actions' => '\\StructType\\PO301000Actions',
            'PO301000DocumentSummary' => '\\StructType\\PO301000DocumentSummary',
            'PO301000DocumentSummaryServiceCommands' => '\\StructType\\PO301000DocumentSummaryServiceCommands',
            'PO301000ShippingInstructionsShipToShippingDestinationType' => '\\StructType\\PO301000ShippingInstructionsShipToShippingDestinationType',
            'PO301000ShippingInstructionsShipToShippingDestinationTypeServiceCommands' => '\\StructType\\PO301000ShippingInstructionsShipToShippingDestinationTypeServiceCommands',
            'PO301000ShippingInstructionsShipVia' => '\\StructType\\PO301000ShippingInstructionsShipVia',
            'PO301000ShippingInstructionsShipViaServiceCommands' => '\\StructType\\PO301000ShippingInstructionsShipViaServiceCommands',
            'PO301000VendorInfoInfo' => '\\StructType\\PO301000VendorInfoInfo',
            'PO301000VendorInfoInfoServiceCommands' => '\\StructType\\PO301000VendorInfoInfoServiceCommands',
            'PO301000OtherInformation' => '\\StructType\\PO301000OtherInformation',
            'PO301000OtherInformationServiceCommands' => '\\StructType\\PO301000OtherInformationServiceCommands',
            'PO301000DocumentDetails' => '\\StructType\\PO301000DocumentDetails',
            'PO301000DocumentDetailsServiceCommands' => '\\StructType\\PO301000DocumentDetailsServiceCommands',
            'PO301000TaxDetails' => '\\StructType\\PO301000TaxDetails',
            'PO301000TaxDetailsServiceCommands' => '\\StructType\\PO301000TaxDetailsServiceCommands',
            'PO301000VendorInfoVendorAddress' => '\\StructType\\PO301000VendorInfoVendorAddress',
            'PO301000VendorInfoVendorAddressServiceCommands' => '\\StructType\\PO301000VendorInfoVendorAddressServiceCommands',
            'PO301000VendorInfoVendorAddressOverride' => '\\StructType\\PO301000VendorInfoVendorAddressOverride',
            'PO301000VendorInfoVendorAddressOverrideServiceCommands' => '\\StructType\\PO301000VendorInfoVendorAddressOverrideServiceCommands',
            'PO301000ShippingInstructionsShipTo' => '\\StructType\\PO301000ShippingInstructionsShipTo',
            'PO301000ShippingInstructionsShipToServiceCommands' => '\\StructType\\PO301000ShippingInstructionsShipToServiceCommands',
            'PO301000ShippingInstructionsShipToOverride' => '\\StructType\\PO301000ShippingInstructionsShipToOverride',
            'PO301000ShippingInstructionsShipToOverrideServiceCommands' => '\\StructType\\PO301000ShippingInstructionsShipToOverrideServiceCommands',
            'PO301000ApprovalDetails' => '\\StructType\\PO301000ApprovalDetails',
            'PO301000ApprovalDetailsServiceCommands' => '\\StructType\\PO301000ApprovalDetailsServiceCommands',
            'PO301000DemandRefNbr' => '\\StructType\\PO301000DemandRefNbr',
            'PO301000DemandRefNbrServiceCommands' => '\\StructType\\PO301000DemandRefNbrServiceCommands',
            'PO301000DocumentSummaryRateSelection' => '\\StructType\\PO301000DocumentSummaryRateSelection',
            'PO301000DocumentSummaryRateSelectionServiceCommands' => '\\StructType\\PO301000DocumentSummaryRateSelectionServiceCommands',
            'PO301000DocumentSummaryRateSelectionCurrencyUnitEquivalents' => '\\StructType\\PO301000DocumentSummaryRateSelectionCurrencyUnitEquivalents',
            'PO301000DocumentSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\PO301000DocumentSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands',
            'PO301000Receipts' => '\\StructType\\PO301000Receipts',
            'PO301000ReceiptsServiceCommands' => '\\StructType\\PO301000ReceiptsServiceCommands',
            'PO301000InventoryLookupInventory' => '\\StructType\\PO301000InventoryLookupInventory',
            'PO301000InventoryLookupInventoryServiceCommands' => '\\StructType\\PO301000InventoryLookupInventoryServiceCommands',
            'PO301000InventoryLookup' => '\\StructType\\PO301000InventoryLookup',
            'PO301000InventoryLookupServiceCommands' => '\\StructType\\PO301000InventoryLookupServiceCommands',
            'PO301000AddPurchaseOrderLinePOSelection' => '\\StructType\\PO301000AddPurchaseOrderLinePOSelection',
            'PO301000AddPurchaseOrderLinePOSelectionServiceCommands' => '\\StructType\\PO301000AddPurchaseOrderLinePOSelectionServiceCommands',
            'PO301000AddPurchaseOrderLine' => '\\StructType\\PO301000AddPurchaseOrderLine',
            'PO301000AddPurchaseOrderLineServiceCommands' => '\\StructType\\PO301000AddPurchaseOrderLineServiceCommands',
            'PO301000AddPurchaseOrder' => '\\StructType\\PO301000AddPurchaseOrder',
            'PO301000AddPurchaseOrderServiceCommands' => '\\StructType\\PO301000AddPurchaseOrderServiceCommands',
            'PO301000Demand' => '\\StructType\\PO301000Demand',
            'PO301000DemandServiceCommands' => '\\StructType\\PO301000DemandServiceCommands',
            'PO301000RecalculatePrices' => '\\StructType\\PO301000RecalculatePrices',
            'PO301000RecalculatePricesServiceCommands' => '\\StructType\\PO301000RecalculatePricesServiceCommands',
            'PO301000PrimaryKey' => '\\StructType\\PO301000PrimaryKey',
            'PO301000Clear' => '\\StructType\\PO301000Clear',
            'PO301000ClearResponse' => '\\StructType\\PO301000ClearResponse',
            'PO301000GetProcessStatus' => '\\StructType\\PO301000GetProcessStatus',
            'PO301000GetProcessStatusResponse' => '\\StructType\\PO301000GetProcessStatusResponse',
            'PO301000GetSchema' => '\\StructType\\PO301000GetSchema',
            'PO301000GetSchemaResponse' => '\\StructType\\PO301000GetSchemaResponse',
            'PO301000SetSchema' => '\\StructType\\PO301000SetSchema',
            'PO301000SetSchemaResponse' => '\\StructType\\PO301000SetSchemaResponse',
            'PO301000Export' => '\\StructType\\PO301000Export',
            'PO301000ExportResponse' => '\\StructType\\PO301000ExportResponse',
            'PO301000Import' => '\\StructType\\PO301000Import',
            'PO301000ImportResponse' => '\\StructType\\PO301000ImportResponse',
            'PO301000ImportResult' => '\\StructType\\PO301000ImportResult',
            'PO301000ArrayOfImportResult' => '\\ArrayType\\PO301000ArrayOfImportResult',
            'PO301000Submit' => '\\StructType\\PO301000Submit',
            'PO301000ArrayOfContent' => '\\ArrayType\\PO301000ArrayOfContent',
            'PO301000SubmitResponse' => '\\StructType\\PO301000SubmitResponse',
            'PO302000Content' => '\\StructType\\PO302000Content',
            'PO302000Actions' => '\\StructType\\PO302000Actions',
            'PO302000DocumentSummary' => '\\StructType\\PO302000DocumentSummary',
            'PO302000DocumentSummaryServiceCommands' => '\\StructType\\PO302000DocumentSummaryServiceCommands',
            'PO302000FinancialDetailsBillingSettings' => '\\StructType\\PO302000FinancialDetailsBillingSettings',
            'PO302000FinancialDetailsBillingSettingsServiceCommands' => '\\StructType\\PO302000FinancialDetailsBillingSettingsServiceCommands',
            'PO302000FinancialDetailsTotals' => '\\StructType\\PO302000FinancialDetailsTotals',
            'PO302000FinancialDetailsTotalsServiceCommands' => '\\StructType\\PO302000FinancialDetailsTotalsServiceCommands',
            'PO302000FinancialDetailsAssignTo' => '\\StructType\\PO302000FinancialDetailsAssignTo',
            'PO302000FinancialDetailsAssignToServiceCommands' => '\\StructType\\PO302000FinancialDetailsAssignToServiceCommands',
            'PO302000DocumentDetails' => '\\StructType\\PO302000DocumentDetails',
            'PO302000DocumentDetailsServiceCommands' => '\\StructType\\PO302000DocumentDetailsServiceCommands',
            'PO302000Allocations' => '\\StructType\\PO302000Allocations',
            'PO302000AllocationsServiceCommands' => '\\StructType\\PO302000AllocationsServiceCommands',
            'PO302000TaxDetails' => '\\StructType\\PO302000TaxDetails',
            'PO302000TaxDetailsServiceCommands' => '\\StructType\\PO302000TaxDetailsServiceCommands',
            'PO302000LandedCosts' => '\\StructType\\PO302000LandedCosts',
            'PO302000LandedCostsServiceCommands' => '\\StructType\\PO302000LandedCostsServiceCommands',
            'PO302000DocumentSummaryRateSelection' => '\\StructType\\PO302000DocumentSummaryRateSelection',
            'PO302000DocumentSummaryRateSelectionServiceCommands' => '\\StructType\\PO302000DocumentSummaryRateSelectionServiceCommands',
            'PO302000DocumentSummaryRateSelectionCurrencyUnitEquivalents' => '\\StructType\\PO302000DocumentSummaryRateSelectionCurrencyUnitEquivalents',
            'PO302000DocumentSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\PO302000DocumentSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands',
            'PO302000LandedCostsRateSelection' => '\\StructType\\PO302000LandedCostsRateSelection',
            'PO302000LandedCostsRateSelectionServiceCommands' => '\\StructType\\PO302000LandedCostsRateSelectionServiceCommands',
            'PO302000LandedCostsRateSelectionCurrencyUnitEquivalents' => '\\StructType\\PO302000LandedCostsRateSelectionCurrencyUnitEquivalents',
            'PO302000LandedCostsRateSelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\PO302000LandedCostsRateSelectionCurrencyUnitEquivalentsServiceCommands',
            'PO302000LandedCostsCurrencySelection' => '\\StructType\\PO302000LandedCostsCurrencySelection',
            'PO302000LandedCostsCurrencySelectionServiceCommands' => '\\StructType\\PO302000LandedCostsCurrencySelectionServiceCommands',
            'PO302000LandedCostsCurrencySelectionCurrencyUnitEquivalents' => '\\StructType\\PO302000LandedCostsCurrencySelectionCurrencyUnitEquivalents',
            'PO302000LandedCostsCurrencySelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\PO302000LandedCostsCurrencySelectionCurrencyUnitEquivalentsServiceCommands',
            'PO302000AddTransferOrder' => '\\StructType\\PO302000AddTransferOrder',
            'PO302000AddTransferOrderServiceCommands' => '\\StructType\\PO302000AddTransferOrderServiceCommands',
            'PO302000RecalculatePricesAndDiscounts' => '\\StructType\\PO302000RecalculatePricesAndDiscounts',
            'PO302000RecalculatePricesAndDiscountsServiceCommands' => '\\StructType\\PO302000RecalculatePricesAndDiscountsServiceCommands',
            'PO302000AddPurchaseOrderLinePOSelection' => '\\StructType\\PO302000AddPurchaseOrderLinePOSelection',
            'PO302000AddPurchaseOrderLinePOSelectionServiceCommands' => '\\StructType\\PO302000AddPurchaseOrderLinePOSelectionServiceCommands',
            'PO302000AddPurchaseOrderPOSelection' => '\\StructType\\PO302000AddPurchaseOrderPOSelection',
            'PO302000AddPurchaseOrderPOSelectionServiceCommands' => '\\StructType\\PO302000AddPurchaseOrderPOSelectionServiceCommands',
            'PO302000AddTransferOrderPOSelection' => '\\StructType\\PO302000AddTransferOrderPOSelection',
            'PO302000AddTransferOrderPOSelectionServiceCommands' => '\\StructType\\PO302000AddTransferOrderPOSelectionServiceCommands',
            'PO302000AddTransferLineTransferSelection' => '\\StructType\\PO302000AddTransferLineTransferSelection',
            'PO302000AddTransferLineTransferSelectionServiceCommands' => '\\StructType\\PO302000AddTransferLineTransferSelectionServiceCommands',
            'PO302000AddReceiptLine' => '\\StructType\\PO302000AddReceiptLine',
            'PO302000AddReceiptLineServiceCommands' => '\\StructType\\PO302000AddReceiptLineServiceCommands',
            'PO302000AddTransferLine' => '\\StructType\\PO302000AddTransferLine',
            'PO302000AddTransferLineServiceCommands' => '\\StructType\\PO302000AddTransferLineServiceCommands',
            'PO302000AllocationsUnassignedQty' => '\\StructType\\PO302000AllocationsUnassignedQty',
            'PO302000AllocationsUnassignedQtyServiceCommands' => '\\StructType\\PO302000AllocationsUnassignedQtyServiceCommands',
            'PO302000AddPurchaseOrderLine' => '\\StructType\\PO302000AddPurchaseOrderLine',
            'PO302000AddPurchaseOrderLineServiceCommands' => '\\StructType\\PO302000AddPurchaseOrderLineServiceCommands',
            'PO302000AddPurchaseOrder' => '\\StructType\\PO302000AddPurchaseOrder',
            'PO302000AddPurchaseOrderServiceCommands' => '\\StructType\\PO302000AddPurchaseOrderServiceCommands',
            'PO302000PrimaryKey' => '\\StructType\\PO302000PrimaryKey',
            'PO302000Clear' => '\\StructType\\PO302000Clear',
            'PO302000ClearResponse' => '\\StructType\\PO302000ClearResponse',
            'PO302000GetProcessStatus' => '\\StructType\\PO302000GetProcessStatus',
            'PO302000GetProcessStatusResponse' => '\\StructType\\PO302000GetProcessStatusResponse',
            'PO302000GetSchema' => '\\StructType\\PO302000GetSchema',
            'PO302000GetSchemaResponse' => '\\StructType\\PO302000GetSchemaResponse',
            'PO302000SetSchema' => '\\StructType\\PO302000SetSchema',
            'PO302000SetSchemaResponse' => '\\StructType\\PO302000SetSchemaResponse',
            'PO302000Export' => '\\StructType\\PO302000Export',
            'PO302000ExportResponse' => '\\StructType\\PO302000ExportResponse',
            'PO302000Import' => '\\StructType\\PO302000Import',
            'PO302000ImportResponse' => '\\StructType\\PO302000ImportResponse',
            'PO302000ImportResult' => '\\StructType\\PO302000ImportResult',
            'PO302000ArrayOfImportResult' => '\\ArrayType\\PO302000ArrayOfImportResult',
            'PO302000Submit' => '\\StructType\\PO302000Submit',
            'PO302000ArrayOfContent' => '\\ArrayType\\PO302000ArrayOfContent',
            'PO302000SubmitResponse' => '\\StructType\\PO302000SubmitResponse',
            'SO301000Content' => '\\StructType\\SO301000Content',
            'SO301000Actions' => '\\StructType\\SO301000Actions',
            'SO301000OrderSummary' => '\\StructType\\SO301000OrderSummary',
            'SO301000OrderSummaryServiceCommands' => '\\StructType\\SO301000OrderSummaryServiceCommands',
            'SO301000CommissionsDefaultSalesperson' => '\\StructType\\SO301000CommissionsDefaultSalesperson',
            'SO301000CommissionsDefaultSalespersonServiceCommands' => '\\StructType\\SO301000CommissionsDefaultSalespersonServiceCommands',
            'SO301000FinancialSettingsFinancialInformation' => '\\StructType\\SO301000FinancialSettingsFinancialInformation',
            'SO301000FinancialSettingsFinancialInformationServiceCommands' => '\\StructType\\SO301000FinancialSettingsFinancialInformationServiceCommands',
            'SO301000PaymentSettings' => '\\StructType\\SO301000PaymentSettings',
            'SO301000PaymentSettingsServiceCommands' => '\\StructType\\SO301000PaymentSettingsServiceCommands',
            'SO301000ShippingSettingsShippingInformation' => '\\StructType\\SO301000ShippingSettingsShippingInformation',
            'SO301000ShippingSettingsShippingInformationServiceCommands' => '\\StructType\\SO301000ShippingSettingsShippingInformationServiceCommands',
            'SO301000Totals' => '\\StructType\\SO301000Totals',
            'SO301000TotalsServiceCommands' => '\\StructType\\SO301000TotalsServiceCommands',
            'SO301000ShopForRatesServicesSettings' => '\\StructType\\SO301000ShopForRatesServicesSettings',
            'SO301000ShopForRatesServicesSettingsServiceCommands' => '\\StructType\\SO301000ShopForRatesServicesSettingsServiceCommands',
            'SO301000ShopForRatesServicesSettingsIsManualPackage' => '\\StructType\\SO301000ShopForRatesServicesSettingsIsManualPackage',
            'SO301000ShopForRatesServicesSettingsIsManualPackageServiceCommands' => '\\StructType\\SO301000ShopForRatesServicesSettingsIsManualPackageServiceCommands',
            'SO301000DocumentDetails' => '\\StructType\\SO301000DocumentDetails',
            'SO301000DocumentDetailsServiceCommands' => '\\StructType\\SO301000DocumentDetailsServiceCommands',
            'SO301000PurchasingDetailsPurchasingSettings' => '\\StructType\\SO301000PurchasingDetailsPurchasingSettings',
            'SO301000PurchasingDetailsPurchasingSettingsServiceCommands' => '\\StructType\\SO301000PurchasingDetailsPurchasingSettingsServiceCommands',
            'SO301000TaxDetails' => '\\StructType\\SO301000TaxDetails',
            'SO301000TaxDetailsServiceCommands' => '\\StructType\\SO301000TaxDetailsServiceCommands',
            'SO301000Shipments' => '\\StructType\\SO301000Shipments',
            'SO301000ShipmentsServiceCommands' => '\\StructType\\SO301000ShipmentsServiceCommands',
            'SO301000FinancialSettingsBillToInfo' => '\\StructType\\SO301000FinancialSettingsBillToInfo',
            'SO301000FinancialSettingsBillToInfoServiceCommands' => '\\StructType\\SO301000FinancialSettingsBillToInfoServiceCommands',
            'SO301000ShippingSettingsShipToInfo' => '\\StructType\\SO301000ShippingSettingsShipToInfo',
            'SO301000ShippingSettingsShipToInfoServiceCommands' => '\\StructType\\SO301000ShippingSettingsShipToInfoServiceCommands',
            'SO301000FinancialSettingsBillToInfoOverrideContact' => '\\StructType\\SO301000FinancialSettingsBillToInfoOverrideContact',
            'SO301000FinancialSettingsBillToInfoOverrideContactServiceCommands' => '\\StructType\\SO301000FinancialSettingsBillToInfoOverrideContactServiceCommands',
            'SO301000ShippingSettingsShipToInfoOverrideContact' => '\\StructType\\SO301000ShippingSettingsShipToInfoOverrideContact',
            'SO301000ShippingSettingsShipToInfoOverrideContactServiceCommands' => '\\StructType\\SO301000ShippingSettingsShipToInfoOverrideContactServiceCommands',
            'SO301000ApprovalDetails' => '\\StructType\\SO301000ApprovalDetails',
            'SO301000ApprovalDetailsServiceCommands' => '\\StructType\\SO301000ApprovalDetailsServiceCommands',
            'SO301000OrderSummaryRateSelection' => '\\StructType\\SO301000OrderSummaryRateSelection',
            'SO301000OrderSummaryRateSelectionServiceCommands' => '\\StructType\\SO301000OrderSummaryRateSelectionServiceCommands',
            'SO301000OrderSummaryRateSelectionCurrencyUnitEquivalents' => '\\StructType\\SO301000OrderSummaryRateSelectionCurrencyUnitEquivalents',
            'SO301000OrderSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\SO301000OrderSummaryRateSelectionCurrencyUnitEquivalentsServiceCommands',
            'SO301000Allocations' => '\\StructType\\SO301000Allocations',
            'SO301000AllocationsServiceCommands' => '\\StructType\\SO301000AllocationsServiceCommands',
            'SO301000SpecifyShipmentParameters' => '\\StructType\\SO301000SpecifyShipmentParameters',
            'SO301000SpecifyShipmentParametersServiceCommands' => '\\StructType\\SO301000SpecifyShipmentParametersServiceCommands',
            'SO301000AddInvoiceDetailsDocType' => '\\StructType\\SO301000AddInvoiceDetailsDocType',
            'SO301000AddInvoiceDetailsDocTypeServiceCommands' => '\\StructType\\SO301000AddInvoiceDetailsDocTypeServiceCommands',
            'SO301000CopyTo' => '\\StructType\\SO301000CopyTo',
            'SO301000CopyToServiceCommands' => '\\StructType\\SO301000CopyToServiceCommands',
            'SO301000RecalculatePrices' => '\\StructType\\SO301000RecalculatePrices',
            'SO301000RecalculatePricesServiceCommands' => '\\StructType\\SO301000RecalculatePricesServiceCommands',
            'SO301000AddInvoiceDetails' => '\\StructType\\SO301000AddInvoiceDetails',
            'SO301000AddInvoiceDetailsServiceCommands' => '\\StructType\\SO301000AddInvoiceDetailsServiceCommands',
            'SO301000PurchasingDetails' => '\\StructType\\SO301000PurchasingDetails',
            'SO301000PurchasingDetailsServiceCommands' => '\\StructType\\SO301000PurchasingDetailsServiceCommands',
            'SO301000ShopForRatesPackages' => '\\StructType\\SO301000ShopForRatesPackages',
            'SO301000ShopForRatesPackagesServiceCommands' => '\\StructType\\SO301000ShopForRatesPackagesServiceCommands',
            'SO301000ShopForRatesCarrierRates' => '\\StructType\\SO301000ShopForRatesCarrierRates',
            'SO301000ShopForRatesCarrierRatesServiceCommands' => '\\StructType\\SO301000ShopForRatesCarrierRatesServiceCommands',
            'SO301000Payments' => '\\StructType\\SO301000Payments',
            'SO301000PaymentsServiceCommands' => '\\StructType\\SO301000PaymentsServiceCommands',
            'SO301000ROTRUTDetailsRUTAndROTSettings' => '\\StructType\\SO301000ROTRUTDetailsRUTAndROTSettings',
            'SO301000ROTRUTDetailsRUTAndROTSettingsServiceCommands' => '\\StructType\\SO301000ROTRUTDetailsRUTAndROTSettingsServiceCommands',
            'SO301000ROTRUTDetailsRUTAndROTTotals' => '\\StructType\\SO301000ROTRUTDetailsRUTAndROTTotals',
            'SO301000ROTRUTDetailsRUTAndROTTotalsServiceCommands' => '\\StructType\\SO301000ROTRUTDetailsRUTAndROTTotalsServiceCommands',
            'SO301000PaymentSettingsInputMode' => '\\StructType\\SO301000PaymentSettingsInputMode',
            'SO301000PaymentSettingsInputModeServiceCommands' => '\\StructType\\SO301000PaymentSettingsInputModeServiceCommands',
            'SO301000PaymentSettingsCardInfo' => '\\StructType\\SO301000PaymentSettingsCardInfo',
            'SO301000PaymentSettingsCardInfoServiceCommands' => '\\StructType\\SO301000PaymentSettingsCardInfoServiceCommands',
            'SO301000PaymentSettingsDescription' => '\\StructType\\SO301000PaymentSettingsDescription',
            'SO301000PaymentSettingsDescriptionServiceCommands' => '\\StructType\\SO301000PaymentSettingsDescriptionServiceCommands',
            'SO301000InventoryLookupInventory' => '\\StructType\\SO301000InventoryLookupInventory',
            'SO301000InventoryLookupInventoryServiceCommands' => '\\StructType\\SO301000InventoryLookupInventoryServiceCommands',
            'SO301000InventoryLookup' => '\\StructType\\SO301000InventoryLookup',
            'SO301000InventoryLookupServiceCommands' => '\\StructType\\SO301000InventoryLookupServiceCommands',
            'SO301000AllocationsUnassignedQty' => '\\StructType\\SO301000AllocationsUnassignedQty',
            'SO301000AllocationsUnassignedQtyServiceCommands' => '\\StructType\\SO301000AllocationsUnassignedQtyServiceCommands',
            'SO301000PrimaryKey' => '\\StructType\\SO301000PrimaryKey',
            'SO301000Clear' => '\\StructType\\SO301000Clear',
            'SO301000ClearResponse' => '\\StructType\\SO301000ClearResponse',
            'SO301000GetProcessStatus' => '\\StructType\\SO301000GetProcessStatus',
            'SO301000GetProcessStatusResponse' => '\\StructType\\SO301000GetProcessStatusResponse',
            'SO301000GetSchema' => '\\StructType\\SO301000GetSchema',
            'SO301000GetSchemaResponse' => '\\StructType\\SO301000GetSchemaResponse',
            'SO301000SetSchema' => '\\StructType\\SO301000SetSchema',
            'SO301000SetSchemaResponse' => '\\StructType\\SO301000SetSchemaResponse',
            'SO301000Export' => '\\StructType\\SO301000Export',
            'SO301000ExportResponse' => '\\StructType\\SO301000ExportResponse',
            'SO301000Import' => '\\StructType\\SO301000Import',
            'SO301000ImportResponse' => '\\StructType\\SO301000ImportResponse',
            'SO301000ImportResult' => '\\StructType\\SO301000ImportResult',
            'SO301000ArrayOfImportResult' => '\\ArrayType\\SO301000ArrayOfImportResult',
            'SO301000Submit' => '\\StructType\\SO301000Submit',
            'SO301000ArrayOfContent' => '\\ArrayType\\SO301000ArrayOfContent',
            'SO301000SubmitResponse' => '\\StructType\\SO301000SubmitResponse',
            'SO302000Content' => '\\StructType\\SO302000Content',
            'SO302000Actions' => '\\StructType\\SO302000Actions',
            'SO302000ShipmentSummary' => '\\StructType\\SO302000ShipmentSummary',
            'SO302000ShipmentSummaryServiceCommands' => '\\StructType\\SO302000ShipmentSummaryServiceCommands',
            'SO302000ShippingSettingsShippingInformation' => '\\StructType\\SO302000ShippingSettingsShippingInformation',
            'SO302000ShippingSettingsShippingInformationServiceCommands' => '\\StructType\\SO302000ShippingSettingsShippingInformationServiceCommands',
            'SO302000DocumentDetails' => '\\StructType\\SO302000DocumentDetails',
            'SO302000DocumentDetailsServiceCommands' => '\\StructType\\SO302000DocumentDetailsServiceCommands',
            'SO302000Allocations' => '\\StructType\\SO302000Allocations',
            'SO302000AllocationsServiceCommands' => '\\StructType\\SO302000AllocationsServiceCommands',
            'SO302000ShippingSettingsShipToInfo' => '\\StructType\\SO302000ShippingSettingsShipToInfo',
            'SO302000ShippingSettingsShipToInfoServiceCommands' => '\\StructType\\SO302000ShippingSettingsShipToInfoServiceCommands',
            'SO302000ShippingSettingsShipToInfoOverrideContact' => '\\StructType\\SO302000ShippingSettingsShipToInfoOverrideContact',
            'SO302000ShippingSettingsShipToInfoOverrideContactServiceCommands' => '\\StructType\\SO302000ShippingSettingsShipToInfoOverrideContactServiceCommands',
            'SO302000Orders' => '\\StructType\\SO302000Orders',
            'SO302000OrdersServiceCommands' => '\\StructType\\SO302000OrdersServiceCommands',
            'SO302000Packages' => '\\StructType\\SO302000Packages',
            'SO302000PackagesServiceCommands' => '\\StructType\\SO302000PackagesServiceCommands',
            'SO302000ShippingSettingsShippingInformationRateSelection' => '\\StructType\\SO302000ShippingSettingsShippingInformationRateSelection',
            'SO302000ShippingSettingsShippingInformationRateSelectionServiceCommands' => '\\StructType\\SO302000ShippingSettingsShippingInformationRateSelectionServiceCommands',
            'SO302000ShippingSettingsShippingInformationRateSelectionCurrencyUnitEquivalents' => '\\StructType\\SO302000ShippingSettingsShippingInformationRateSelectionCurrencyUnitEquivalents',
            'SO302000ShippingSettingsShippingInformationRateSelectionCurrencyUnitEquivalentsServiceCommands' => '\\StructType\\SO302000ShippingSettingsShippingInformationRateSelectionCurrencyUnitEquivalentsServiceCommands',
            'SO302000AddSalesOrderOperation' => '\\StructType\\SO302000AddSalesOrderOperation',
            'SO302000AddSalesOrderOperationServiceCommands' => '\\StructType\\SO302000AddSalesOrderOperationServiceCommands',
            'SO302000AddSalesOrder' => '\\StructType\\SO302000AddSalesOrder',
            'SO302000AddSalesOrderServiceCommands' => '\\StructType\\SO302000AddSalesOrderServiceCommands',
            'SO302000AllocationsUnassignedQty' => '\\StructType\\SO302000AllocationsUnassignedQty',
            'SO302000AllocationsUnassignedQtyServiceCommands' => '\\StructType\\SO302000AllocationsUnassignedQtyServiceCommands',
            'SO302000PrimaryKey' => '\\StructType\\SO302000PrimaryKey',
            'SO302000Clear' => '\\StructType\\SO302000Clear',
            'SO302000ClearResponse' => '\\StructType\\SO302000ClearResponse',
            'SO302000GetProcessStatus' => '\\StructType\\SO302000GetProcessStatus',
            'SO302000GetProcessStatusResponse' => '\\StructType\\SO302000GetProcessStatusResponse',
            'SO302000GetSchema' => '\\StructType\\SO302000GetSchema',
            'SO302000GetSchemaResponse' => '\\StructType\\SO302000GetSchemaResponse',
            'SO302000SetSchema' => '\\StructType\\SO302000SetSchema',
            'SO302000SetSchemaResponse' => '\\StructType\\SO302000SetSchemaResponse',
            'SO302000Export' => '\\StructType\\SO302000Export',
            'SO302000ExportResponse' => '\\StructType\\SO302000ExportResponse',
            'SO302000Import' => '\\StructType\\SO302000Import',
            'SO302000ImportResponse' => '\\StructType\\SO302000ImportResponse',
            'SO302000ImportResult' => '\\StructType\\SO302000ImportResult',
            'SO302000ArrayOfImportResult' => '\\ArrayType\\SO302000ArrayOfImportResult',
            'SO302000Submit' => '\\StructType\\SO302000Submit',
            'SO302000ArrayOfContent' => '\\ArrayType\\SO302000ArrayOfContent',
            'SO302000SubmitResponse' => '\\StructType\\SO302000SubmitResponse',
        );
    }
}
