<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for templateVariable StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class TemplateVariable extends AbstractStructBase
{
    /**
     * The variableType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $variableType;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\TemplateVariableValue
     */
    public $value;
    /**
     * Constructor method for templateVariable
     * @uses TemplateVariable::setVariableType()
     * @uses TemplateVariable::setValue()
     * @param string $variableType
     * @param \GraphikDimensions\StructType\TemplateVariableValue $value
     */
    public function __construct($variableType = null, \GraphikDimensions\StructType\TemplateVariableValue $value = null)
    {
        $this
            ->setVariableType($variableType)
            ->setValue($value);
    }
    /**
     * Get variableType value
     * @return string|null
     */
    public function getVariableType()
    {
        return $this->variableType;
    }
    /**
     * Set variableType value
     * @uses \GraphikDimensions\EnumType\TemplateVariableType::valueIsValid()
     * @uses \GraphikDimensions\EnumType\TemplateVariableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $variableType
     * @return \GraphikDimensions\StructType\TemplateVariable
     */
    public function setVariableType($variableType = null)
    {
        // validation for constraint: enumeration
        if (!\GraphikDimensions\EnumType\TemplateVariableType::valueIsValid($variableType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $variableType, implode(', ', \GraphikDimensions\EnumType\TemplateVariableType::getValidValues())), __LINE__);
        }
        $this->variableType = $variableType;
        return $this;
    }
    /**
     * Get value value
     * @return \GraphikDimensions\StructType\TemplateVariableValue|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param \GraphikDimensions\StructType\TemplateVariableValue $value
     * @return \GraphikDimensions\StructType\TemplateVariable
     */
    public function setValue(\GraphikDimensions\StructType\TemplateVariableValue $value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\TemplateVariable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
