<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for image StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class Image extends DimensionedExternalProduct
{
    /**
     * The borderColor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $borderColor;
    /**
     * The borderStyle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $borderStyle;
    /**
     * The bottomBorder
     * @var float
     */
    public $bottomBorder;
    /**
     * The certOfAuth
     * @var bool
     */
    public $certOfAuth;
    /**
     * The externalMedia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\ExternalMedia
     */
    public $externalMedia;
    /**
     * The imageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imageName;
    /**
     * The imageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imageType;
    /**
     * The imageURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imageURL;
    /**
     * The leftBorder
     * @var float
     */
    public $leftBorder;
    /**
     * The proofStamp
     * @var bool
     */
    public $proofStamp;
    /**
     * The rightBorder
     * @var float
     */
    public $rightBorder;
    /**
     * The royaltyFee
     * @var float
     */
    public $royaltyFee;
    /**
     * The topBorder
     * @var float
     */
    public $topBorder;
    /**
     * Constructor method for image
     * @uses Image::setBorderColor()
     * @uses Image::setBorderStyle()
     * @uses Image::setBottomBorder()
     * @uses Image::setCertOfAuth()
     * @uses Image::setExternalMedia()
     * @uses Image::setImageName()
     * @uses Image::setImageType()
     * @uses Image::setImageURL()
     * @uses Image::setLeftBorder()
     * @uses Image::setProofStamp()
     * @uses Image::setRightBorder()
     * @uses Image::setRoyaltyFee()
     * @uses Image::setTopBorder()
     * @param string $borderColor
     * @param string $borderStyle
     * @param float $bottomBorder
     * @param bool $certOfAuth
     * @param \GraphikDimensions\StructType\ExternalMedia $externalMedia
     * @param string $imageName
     * @param string $imageType
     * @param string $imageURL
     * @param float $leftBorder
     * @param bool $proofStamp
     * @param float $rightBorder
     * @param float $royaltyFee
     * @param float $topBorder
     */
    public function __construct($borderColor = null, $borderStyle = null, $bottomBorder = null, $certOfAuth = null, \GraphikDimensions\StructType\ExternalMedia $externalMedia = null, $imageName = null, $imageType = null, $imageURL = null, $leftBorder = null, $proofStamp = null, $rightBorder = null, $royaltyFee = null, $topBorder = null)
    {
        $this
            ->setBorderColor($borderColor)
            ->setBorderStyle($borderStyle)
            ->setBottomBorder($bottomBorder)
            ->setCertOfAuth($certOfAuth)
            ->setExternalMedia($externalMedia)
            ->setImageName($imageName)
            ->setImageType($imageType)
            ->setImageURL($imageURL)
            ->setLeftBorder($leftBorder)
            ->setProofStamp($proofStamp)
            ->setRightBorder($rightBorder)
            ->setRoyaltyFee($royaltyFee)
            ->setTopBorder($topBorder);
    }
    /**
     * Get borderColor value
     * @return string|null
     */
    public function getBorderColor()
    {
        return $this->borderColor;
    }
    /**
     * Set borderColor value
     * @param string $borderColor
     * @return \GraphikDimensions\StructType\Image
     */
    public function setBorderColor($borderColor = null)
    {
        // validation for constraint: string
        if (!is_null($borderColor) && !is_string($borderColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($borderColor)), __LINE__);
        }
        $this->borderColor = $borderColor;
        return $this;
    }
    /**
     * Get borderStyle value
     * @return string|null
     */
    public function getBorderStyle()
    {
        return $this->borderStyle;
    }
    /**
     * Set borderStyle value
     * @uses \GraphikDimensions\EnumType\BorderStyle::valueIsValid()
     * @uses \GraphikDimensions\EnumType\BorderStyle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $borderStyle
     * @return \GraphikDimensions\StructType\Image
     */
    public function setBorderStyle($borderStyle = null)
    {
        // validation for constraint: enumeration
        if (!\GraphikDimensions\EnumType\BorderStyle::valueIsValid($borderStyle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $borderStyle, implode(', ', \GraphikDimensions\EnumType\BorderStyle::getValidValues())), __LINE__);
        }
        $this->borderStyle = $borderStyle;
        return $this;
    }
    /**
     * Get bottomBorder value
     * @return float|null
     */
    public function getBottomBorder()
    {
        return $this->bottomBorder;
    }
    /**
     * Set bottomBorder value
     * @param float $bottomBorder
     * @return \GraphikDimensions\StructType\Image
     */
    public function setBottomBorder($bottomBorder = null)
    {
        $this->bottomBorder = $bottomBorder;
        return $this;
    }
    /**
     * Get certOfAuth value
     * @return bool|null
     */
    public function getCertOfAuth()
    {
        return $this->certOfAuth;
    }
    /**
     * Set certOfAuth value
     * @param bool $certOfAuth
     * @return \GraphikDimensions\StructType\Image
     */
    public function setCertOfAuth($certOfAuth = null)
    {
        $this->certOfAuth = $certOfAuth;
        return $this;
    }
    /**
     * Get externalMedia value
     * @return \GraphikDimensions\StructType\ExternalMedia|null
     */
    public function getExternalMedia()
    {
        return $this->externalMedia;
    }
    /**
     * Set externalMedia value
     * @param \GraphikDimensions\StructType\ExternalMedia $externalMedia
     * @return \GraphikDimensions\StructType\Image
     */
    public function setExternalMedia(\GraphikDimensions\StructType\ExternalMedia $externalMedia = null)
    {
        $this->externalMedia = $externalMedia;
        return $this;
    }
    /**
     * Get imageName value
     * @return string|null
     */
    public function getImageName()
    {
        return $this->imageName;
    }
    /**
     * Set imageName value
     * @param string $imageName
     * @return \GraphikDimensions\StructType\Image
     */
    public function setImageName($imageName = null)
    {
        // validation for constraint: string
        if (!is_null($imageName) && !is_string($imageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageName)), __LINE__);
        }
        $this->imageName = $imageName;
        return $this;
    }
    /**
     * Get imageType value
     * @return string|null
     */
    public function getImageType()
    {
        return $this->imageType;
    }
    /**
     * Set imageType value
     * @uses \GraphikDimensions\EnumType\ImageTypes::valueIsValid()
     * @uses \GraphikDimensions\EnumType\ImageTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageType
     * @return \GraphikDimensions\StructType\Image
     */
    public function setImageType($imageType = null)
    {
        // validation for constraint: enumeration
        if (!\GraphikDimensions\EnumType\ImageTypes::valueIsValid($imageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $imageType, implode(', ', \GraphikDimensions\EnumType\ImageTypes::getValidValues())), __LINE__);
        }
        $this->imageType = $imageType;
        return $this;
    }
    /**
     * Get imageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->imageURL;
    }
    /**
     * Set imageURL value
     * @param string $imageURL
     * @return \GraphikDimensions\StructType\Image
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageURL)), __LINE__);
        }
        $this->imageURL = $imageURL;
        return $this;
    }
    /**
     * Get leftBorder value
     * @return float|null
     */
    public function getLeftBorder()
    {
        return $this->leftBorder;
    }
    /**
     * Set leftBorder value
     * @param float $leftBorder
     * @return \GraphikDimensions\StructType\Image
     */
    public function setLeftBorder($leftBorder = null)
    {
        $this->leftBorder = $leftBorder;
        return $this;
    }
    /**
     * Get proofStamp value
     * @return bool|null
     */
    public function getProofStamp()
    {
        return $this->proofStamp;
    }
    /**
     * Set proofStamp value
     * @param bool $proofStamp
     * @return \GraphikDimensions\StructType\Image
     */
    public function setProofStamp($proofStamp = null)
    {
        $this->proofStamp = $proofStamp;
        return $this;
    }
    /**
     * Get rightBorder value
     * @return float|null
     */
    public function getRightBorder()
    {
        return $this->rightBorder;
    }
    /**
     * Set rightBorder value
     * @param float $rightBorder
     * @return \GraphikDimensions\StructType\Image
     */
    public function setRightBorder($rightBorder = null)
    {
        $this->rightBorder = $rightBorder;
        return $this;
    }
    /**
     * Get royaltyFee value
     * @return float|null
     */
    public function getRoyaltyFee()
    {
        return $this->royaltyFee;
    }
    /**
     * Set royaltyFee value
     * @param float $royaltyFee
     * @return \GraphikDimensions\StructType\Image
     */
    public function setRoyaltyFee($royaltyFee = null)
    {
        $this->royaltyFee = $royaltyFee;
        return $this;
    }
    /**
     * Get topBorder value
     * @return float|null
     */
    public function getTopBorder()
    {
        return $this->topBorder;
    }
    /**
     * Set topBorder value
     * @param float $topBorder
     * @return \GraphikDimensions\StructType\Image
     */
    public function setTopBorder($topBorder = null)
    {
        $this->topBorder = $topBorder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\Image
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
