<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalProductPackage StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class ExternalProductPackage extends ExternalProduct
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customerId;
    /**
     * The customerSuppliedImagery
     * @var bool
     */
    public $customerSuppliedImagery;
    /**
     * The externalOrderId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $externalOrderId;
    /**
     * The fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\Fee[]
     */
    public $fees;
    /**
     * The newPackageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $newPackageType;
    /**
     * The outsideDimensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outsideDimensions;
    /**
     * The packageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packageName;
    /**
     * The packagePriceData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\PackagePriceData
     */
    public $packagePriceData;
    /**
     * The packageSkus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $packageSkus;
    /**
     * The products
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GraphikDimensions\StructType\ExternalProduct[]
     */
    public $products;
    /**
     * The renderTemplate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $renderTemplate;
    /**
     * Constructor method for externalProductPackage
     * @uses ExternalProductPackage::setCustomerId()
     * @uses ExternalProductPackage::setCustomerSuppliedImagery()
     * @uses ExternalProductPackage::setExternalOrderId()
     * @uses ExternalProductPackage::setFees()
     * @uses ExternalProductPackage::setNewPackageType()
     * @uses ExternalProductPackage::setOutsideDimensions()
     * @uses ExternalProductPackage::setPackageName()
     * @uses ExternalProductPackage::setPackagePriceData()
     * @uses ExternalProductPackage::setPackageSkus()
     * @uses ExternalProductPackage::setProducts()
     * @uses ExternalProductPackage::setRenderTemplate()
     * @param int $customerId
     * @param bool $customerSuppliedImagery
     * @param int $externalOrderId
     * @param \GraphikDimensions\StructType\Fee[] $fees
     * @param string $newPackageType
     * @param string $outsideDimensions
     * @param string $packageName
     * @param \GraphikDimensions\StructType\PackagePriceData $packagePriceData
     * @param string[] $packageSkus
     * @param \GraphikDimensions\StructType\ExternalProduct[] $products
     * @param string $renderTemplate
     */
    public function __construct($customerId = null, $customerSuppliedImagery = null, $externalOrderId = null, array $fees = array(), $newPackageType = null, $outsideDimensions = null, $packageName = null, \GraphikDimensions\StructType\PackagePriceData $packagePriceData = null, array $packageSkus = array(), array $products = array(), $renderTemplate = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCustomerSuppliedImagery($customerSuppliedImagery)
            ->setExternalOrderId($externalOrderId)
            ->setFees($fees)
            ->setNewPackageType($newPackageType)
            ->setOutsideDimensions($outsideDimensions)
            ->setPackageName($packageName)
            ->setPackagePriceData($packagePriceData)
            ->setPackageSkus($packageSkus)
            ->setProducts($products)
            ->setRenderTemplate($renderTemplate);
    }
    /**
     * Get customerId value
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get customerSuppliedImagery value
     * @return bool|null
     */
    public function getCustomerSuppliedImagery()
    {
        return $this->customerSuppliedImagery;
    }
    /**
     * Set customerSuppliedImagery value
     * @param bool $customerSuppliedImagery
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setCustomerSuppliedImagery($customerSuppliedImagery = null)
    {
        $this->customerSuppliedImagery = $customerSuppliedImagery;
        return $this;
    }
    /**
     * Get externalOrderId value
     * @return int|null
     */
    public function getExternalOrderId()
    {
        return $this->externalOrderId;
    }
    /**
     * Set externalOrderId value
     * @param int $externalOrderId
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setExternalOrderId($externalOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($externalOrderId) && !is_numeric($externalOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($externalOrderId)), __LINE__);
        }
        $this->externalOrderId = $externalOrderId;
        return $this;
    }
    /**
     * Get fees value
     * @return \GraphikDimensions\StructType\Fee[]|null
     */
    public function getFees()
    {
        return $this->fees;
    }
    /**
     * Set fees value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\Fee[] $fees
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setFees(array $fees = array())
    {
        foreach ($fees as $externalProductPackageFeesItem) {
            // validation for constraint: itemType
            if (!$externalProductPackageFeesItem instanceof \GraphikDimensions\StructType\Fee) {
                throw new \InvalidArgumentException(sprintf('The fees property can only contain items of \GraphikDimensions\StructType\Fee, "%s" given', is_object($externalProductPackageFeesItem) ? get_class($externalProductPackageFeesItem) : gettype($externalProductPackageFeesItem)), __LINE__);
            }
        }
        $this->fees = $fees;
        return $this;
    }
    /**
     * Add item to fees value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\Fee $item
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function addToFees(\GraphikDimensions\StructType\Fee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\Fee) {
            throw new \InvalidArgumentException(sprintf('The fees property can only contain items of \GraphikDimensions\StructType\Fee, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->fees[] = $item;
        return $this;
    }
    /**
     * Get newPackageType value
     * @return string|null
     */
    public function getNewPackageType()
    {
        return $this->newPackageType;
    }
    /**
     * Set newPackageType value
     * @param string $newPackageType
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setNewPackageType($newPackageType = null)
    {
        // validation for constraint: string
        if (!is_null($newPackageType) && !is_string($newPackageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPackageType)), __LINE__);
        }
        $this->newPackageType = $newPackageType;
        return $this;
    }
    /**
     * Get outsideDimensions value
     * @return string|null
     */
    public function getOutsideDimensions()
    {
        return $this->outsideDimensions;
    }
    /**
     * Set outsideDimensions value
     * @param string $outsideDimensions
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setOutsideDimensions($outsideDimensions = null)
    {
        // validation for constraint: string
        if (!is_null($outsideDimensions) && !is_string($outsideDimensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outsideDimensions)), __LINE__);
        }
        $this->outsideDimensions = $outsideDimensions;
        return $this;
    }
    /**
     * Get packageName value
     * @return string|null
     */
    public function getPackageName()
    {
        return $this->packageName;
    }
    /**
     * Set packageName value
     * @param string $packageName
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setPackageName($packageName = null)
    {
        // validation for constraint: string
        if (!is_null($packageName) && !is_string($packageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageName)), __LINE__);
        }
        $this->packageName = $packageName;
        return $this;
    }
    /**
     * Get packagePriceData value
     * @return \GraphikDimensions\StructType\PackagePriceData|null
     */
    public function getPackagePriceData()
    {
        return $this->packagePriceData;
    }
    /**
     * Set packagePriceData value
     * @param \GraphikDimensions\StructType\PackagePriceData $packagePriceData
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setPackagePriceData(\GraphikDimensions\StructType\PackagePriceData $packagePriceData = null)
    {
        $this->packagePriceData = $packagePriceData;
        return $this;
    }
    /**
     * Get packageSkus value
     * @return string[]|null
     */
    public function getPackageSkus()
    {
        return $this->packageSkus;
    }
    /**
     * Set packageSkus value
     * @throws \InvalidArgumentException
     * @param string[] $packageSkus
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setPackageSkus(array $packageSkus = array())
    {
        foreach ($packageSkus as $externalProductPackagePackageSkusItem) {
            // validation for constraint: itemType
            if (!is_string($externalProductPackagePackageSkusItem)) {
                throw new \InvalidArgumentException(sprintf('The packageSkus property can only contain items of string, "%s" given', is_object($externalProductPackagePackageSkusItem) ? get_class($externalProductPackagePackageSkusItem) : gettype($externalProductPackagePackageSkusItem)), __LINE__);
            }
        }
        $this->packageSkus = $packageSkus;
        return $this;
    }
    /**
     * Add item to packageSkus value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function addToPackageSkus($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The packageSkus property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->packageSkus[] = $item;
        return $this;
    }
    /**
     * Get products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GraphikDimensions\StructType\ExternalProduct[]|null
     */
    public function getProducts()
    {
        return isset($this->products) ? $this->products : null;
    }
    /**
     * Set products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProduct[] $products
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setProducts(array $products = array())
    {
        foreach ($products as $externalProductPackageProductsItem) {
            // validation for constraint: itemType
            if (!$externalProductPackageProductsItem instanceof \GraphikDimensions\StructType\ExternalProduct) {
                throw new \InvalidArgumentException(sprintf('The products property can only contain items of \GraphikDimensions\StructType\ExternalProduct, "%s" given', is_object($externalProductPackageProductsItem) ? get_class($externalProductPackageProductsItem) : gettype($externalProductPackageProductsItem)), __LINE__);
            }
        }
        if (is_null($products) || (is_array($products) && empty($products))) {
            unset($this->products);
        } else {
            $this->products = $products;
        }
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProduct $item
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function addToProducts(\GraphikDimensions\StructType\ExternalProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ExternalProduct) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of \GraphikDimensions\StructType\ExternalProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Get renderTemplate value
     * @return string|null
     */
    public function getRenderTemplate()
    {
        return $this->renderTemplate;
    }
    /**
     * Set renderTemplate value
     * @param string $renderTemplate
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public function setRenderTemplate($renderTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($renderTemplate) && !is_string($renderTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($renderTemplate)), __LINE__);
        }
        $this->renderTemplate = $renderTemplate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\ExternalProductPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
