<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalProductAttributeGroup StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class ExternalProductAttributeGroup extends AbstractStructBase
{
    /**
     * The displayInd
     * @var int
     */
    public $displayInd;
    /**
     * The displayLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayLabel;
    /**
     * The displayOrder
     * @var int
     */
    public $displayOrder;
    /**
     * The externalProductAttributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GraphikDimensions\StructType\ExternalProductAttribute[]
     */
    public $externalProductAttributes;
    /**
     * The nameText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nameText;
    /**
     * The priority
     * @var int
     */
    public $priority;
    /**
     * The productAttributeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productAttributeType;
    /**
     * Constructor method for externalProductAttributeGroup
     * @uses ExternalProductAttributeGroup::setDisplayInd()
     * @uses ExternalProductAttributeGroup::setDisplayLabel()
     * @uses ExternalProductAttributeGroup::setDisplayOrder()
     * @uses ExternalProductAttributeGroup::setExternalProductAttributes()
     * @uses ExternalProductAttributeGroup::setNameText()
     * @uses ExternalProductAttributeGroup::setPriority()
     * @uses ExternalProductAttributeGroup::setProductAttributeType()
     * @param int $displayInd
     * @param string $displayLabel
     * @param int $displayOrder
     * @param \GraphikDimensions\StructType\ExternalProductAttribute[] $externalProductAttributes
     * @param string $nameText
     * @param int $priority
     * @param string $productAttributeType
     */
    public function __construct($displayInd = null, $displayLabel = null, $displayOrder = null, array $externalProductAttributes = array(), $nameText = null, $priority = null, $productAttributeType = null)
    {
        $this
            ->setDisplayInd($displayInd)
            ->setDisplayLabel($displayLabel)
            ->setDisplayOrder($displayOrder)
            ->setExternalProductAttributes($externalProductAttributes)
            ->setNameText($nameText)
            ->setPriority($priority)
            ->setProductAttributeType($productAttributeType);
    }
    /**
     * Get displayInd value
     * @return int|null
     */
    public function getDisplayInd()
    {
        return $this->displayInd;
    }
    /**
     * Set displayInd value
     * @param int $displayInd
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public function setDisplayInd($displayInd = null)
    {
        // validation for constraint: int
        if (!is_null($displayInd) && !is_numeric($displayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($displayInd)), __LINE__);
        }
        $this->displayInd = $displayInd;
        return $this;
    }
    /**
     * Get displayLabel value
     * @return string|null
     */
    public function getDisplayLabel()
    {
        return $this->displayLabel;
    }
    /**
     * Set displayLabel value
     * @param string $displayLabel
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public function setDisplayLabel($displayLabel = null)
    {
        // validation for constraint: string
        if (!is_null($displayLabel) && !is_string($displayLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayLabel)), __LINE__);
        }
        $this->displayLabel = $displayLabel;
        return $this;
    }
    /**
     * Get displayOrder value
     * @return int|null
     */
    public function getDisplayOrder()
    {
        return $this->displayOrder;
    }
    /**
     * Set displayOrder value
     * @param int $displayOrder
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public function setDisplayOrder($displayOrder = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrder) && !is_numeric($displayOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($displayOrder)), __LINE__);
        }
        $this->displayOrder = $displayOrder;
        return $this;
    }
    /**
     * Get externalProductAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GraphikDimensions\StructType\ExternalProductAttribute[]|null
     */
    public function getExternalProductAttributes()
    {
        return isset($this->externalProductAttributes) ? $this->externalProductAttributes : null;
    }
    /**
     * Set externalProductAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductAttribute[] $externalProductAttributes
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public function setExternalProductAttributes(array $externalProductAttributes = array())
    {
        foreach ($externalProductAttributes as $externalProductAttributeGroupExternalProductAttributesItem) {
            // validation for constraint: itemType
            if (!$externalProductAttributeGroupExternalProductAttributesItem instanceof \GraphikDimensions\StructType\ExternalProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The externalProductAttributes property can only contain items of \GraphikDimensions\StructType\ExternalProductAttribute, "%s" given', is_object($externalProductAttributeGroupExternalProductAttributesItem) ? get_class($externalProductAttributeGroupExternalProductAttributesItem) : gettype($externalProductAttributeGroupExternalProductAttributesItem)), __LINE__);
            }
        }
        if (is_null($externalProductAttributes) || (is_array($externalProductAttributes) && empty($externalProductAttributes))) {
            unset($this->externalProductAttributes);
        } else {
            $this->externalProductAttributes = $externalProductAttributes;
        }
        return $this;
    }
    /**
     * Add item to externalProductAttributes value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductAttribute $item
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public function addToExternalProductAttributes(\GraphikDimensions\StructType\ExternalProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ExternalProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The externalProductAttributes property can only contain items of \GraphikDimensions\StructType\ExternalProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalProductAttributes[] = $item;
        return $this;
    }
    /**
     * Get nameText value
     * @return string|null
     */
    public function getNameText()
    {
        return $this->nameText;
    }
    /**
     * Set nameText value
     * @param string $nameText
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public function setNameText($nameText = null)
    {
        // validation for constraint: string
        if (!is_null($nameText) && !is_string($nameText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameText)), __LINE__);
        }
        $this->nameText = $nameText;
        return $this;
    }
    /**
     * Get priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param int $priority
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !is_numeric($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priority)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get productAttributeType value
     * @return string|null
     */
    public function getProductAttributeType()
    {
        return $this->productAttributeType;
    }
    /**
     * Set productAttributeType value
     * @param string $productAttributeType
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public function setProductAttributeType($productAttributeType = null)
    {
        // validation for constraint: string
        if (!is_null($productAttributeType) && !is_string($productAttributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productAttributeType)), __LINE__);
        }
        $this->productAttributeType = $productAttributeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\ExternalProductAttributeGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
