<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalOrderLineItem StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class ExternalOrderLineItem extends AbstractStructBase
{
    /**
     * The channelItemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GraphikDimensions\StructType\ChannelItemId[]
     */
    public $channelItemId;
    /**
     * The costData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\CostData
     */
    public $costData;
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\ExternalProduct
     */
    public $product;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The userItemId
     * @var string
     */
    public $userItemId;
    /**
     * Constructor method for externalOrderLineItem
     * @uses ExternalOrderLineItem::setChannelItemId()
     * @uses ExternalOrderLineItem::setCostData()
     * @uses ExternalOrderLineItem::setOrderId()
     * @uses ExternalOrderLineItem::setProduct()
     * @uses ExternalOrderLineItem::setQuantity()
     * @uses ExternalOrderLineItem::setUserItemId()
     * @param \GraphikDimensions\StructType\ChannelItemId[] $channelItemId
     * @param \GraphikDimensions\StructType\CostData $costData
     * @param int $orderId
     * @param \GraphikDimensions\StructType\ExternalProduct $product
     * @param int $quantity
     * @param string $userItemId
     */
    public function __construct(array $channelItemId = array(), \GraphikDimensions\StructType\CostData $costData = null, $orderId = null, \GraphikDimensions\StructType\ExternalProduct $product = null, $quantity = null, $userItemId = null)
    {
        $this
            ->setChannelItemId($channelItemId)
            ->setCostData($costData)
            ->setOrderId($orderId)
            ->setProduct($product)
            ->setQuantity($quantity)
            ->setUserItemId($userItemId);
    }
    /**
     * Get channelItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GraphikDimensions\StructType\ChannelItemId[]|null
     */
    public function getChannelItemId()
    {
        return isset($this->channelItemId) ? $this->channelItemId : null;
    }
    /**
     * Set channelItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ChannelItemId[] $channelItemId
     * @return \GraphikDimensions\StructType\ExternalOrderLineItem
     */
    public function setChannelItemId(array $channelItemId = array())
    {
        foreach ($channelItemId as $externalOrderLineItemChannelItemIdItem) {
            // validation for constraint: itemType
            if (!$externalOrderLineItemChannelItemIdItem instanceof \GraphikDimensions\StructType\ChannelItemId) {
                throw new \InvalidArgumentException(sprintf('The channelItemId property can only contain items of \GraphikDimensions\StructType\ChannelItemId, "%s" given', is_object($externalOrderLineItemChannelItemIdItem) ? get_class($externalOrderLineItemChannelItemIdItem) : gettype($externalOrderLineItemChannelItemIdItem)), __LINE__);
            }
        }
        if (is_null($channelItemId) || (is_array($channelItemId) && empty($channelItemId))) {
            unset($this->channelItemId);
        } else {
            $this->channelItemId = $channelItemId;
        }
        return $this;
    }
    /**
     * Add item to channelItemId value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ChannelItemId $item
     * @return \GraphikDimensions\StructType\ExternalOrderLineItem
     */
    public function addToChannelItemId(\GraphikDimensions\StructType\ChannelItemId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ChannelItemId) {
            throw new \InvalidArgumentException(sprintf('The channelItemId property can only contain items of \GraphikDimensions\StructType\ChannelItemId, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->channelItemId[] = $item;
        return $this;
    }
    /**
     * Get costData value
     * @return \GraphikDimensions\StructType\CostData|null
     */
    public function getCostData()
    {
        return $this->costData;
    }
    /**
     * Set costData value
     * @param \GraphikDimensions\StructType\CostData $costData
     * @return \GraphikDimensions\StructType\ExternalOrderLineItem
     */
    public function setCostData(\GraphikDimensions\StructType\CostData $costData = null)
    {
        $this->costData = $costData;
        return $this;
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \GraphikDimensions\StructType\ExternalOrderLineItem
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !is_numeric($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get product value
     * @return \GraphikDimensions\StructType\ExternalProduct|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \GraphikDimensions\StructType\ExternalProduct $product
     * @return \GraphikDimensions\StructType\ExternalOrderLineItem
     */
    public function setProduct(\GraphikDimensions\StructType\ExternalProduct $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \GraphikDimensions\StructType\ExternalOrderLineItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get userItemId value
     * @return string|null
     */
    public function getUserItemId()
    {
        return $this->userItemId;
    }
    /**
     * Set userItemId value
     * @param string $userItemId
     * @return \GraphikDimensions\StructType\ExternalOrderLineItem
     */
    public function setUserItemId($userItemId = null)
    {
        // validation for constraint: string
        if (!is_null($userItemId) && !is_string($userItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userItemId)), __LINE__);
        }
        $this->userItemId = $userItemId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\ExternalOrderLineItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
