<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for collection StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class Collection extends ExternalProduct
{
    /**
     * The products
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\ExternalProduct[]
     */
    public $products;
    /**
     * The skus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $skus;
    /**
     * Constructor method for collection
     * @uses Collection::setProducts()
     * @uses Collection::setSkus()
     * @param \GraphikDimensions\StructType\ExternalProduct[] $products
     * @param string[] $skus
     */
    public function __construct(array $products = array(), array $skus = array())
    {
        $this
            ->setProducts($products)
            ->setSkus($skus);
    }
    /**
     * Get products value
     * @return \GraphikDimensions\StructType\ExternalProduct[]|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProduct[] $products
     * @return \GraphikDimensions\StructType\Collection
     */
    public function setProducts(array $products = array())
    {
        foreach ($products as $collectionProductsItem) {
            // validation for constraint: itemType
            if (!$collectionProductsItem instanceof \GraphikDimensions\StructType\ExternalProduct) {
                throw new \InvalidArgumentException(sprintf('The products property can only contain items of \GraphikDimensions\StructType\ExternalProduct, "%s" given', is_object($collectionProductsItem) ? get_class($collectionProductsItem) : gettype($collectionProductsItem)), __LINE__);
            }
        }
        $this->products = $products;
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProduct $item
     * @return \GraphikDimensions\StructType\Collection
     */
    public function addToProducts(\GraphikDimensions\StructType\ExternalProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ExternalProduct) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of \GraphikDimensions\StructType\ExternalProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Get skus value
     * @return string[]|null
     */
    public function getSkus()
    {
        return $this->skus;
    }
    /**
     * Set skus value
     * @throws \InvalidArgumentException
     * @param string[] $skus
     * @return \GraphikDimensions\StructType\Collection
     */
    public function setSkus(array $skus = array())
    {
        foreach ($skus as $collectionSkusItem) {
            // validation for constraint: itemType
            if (!is_string($collectionSkusItem)) {
                throw new \InvalidArgumentException(sprintf('The skus property can only contain items of string, "%s" given', is_object($collectionSkusItem) ? get_class($collectionSkusItem) : gettype($collectionSkusItem)), __LINE__);
            }
        }
        $this->skus = $skus;
        return $this;
    }
    /**
     * Add item to skus value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GraphikDimensions\StructType\Collection
     */
    public function addToSkus($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The skus property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->skus[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\Collection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
