<?php

namespace GraphikDimensions\EnumType;

/**
 * This class stands for borderStyle EnumType
 * @subpackage Enumerations
 * @date Generated 2017-02-10
 * @author https
 */
class BorderStyle
{
    /**
     * Constant for value 'BR'
     * @return string 'BR'
     */
    const VALUE_BR = 'BR';
    /**
     * Constant for value 'BL'
     * @return string 'BL'
     */
    const VALUE_BL = 'BL';
    /**
     * Constant for value 'HX'
     * @return string 'HX'
     */
    const VALUE_HX = 'HX';
    /**
     * Constant for value 'CI'
     * @return string 'CI'
     */
    const VALUE_CI = 'CI';
    /**
     * Constant for value 'SW'
     * @return string 'SW'
     */
    const VALUE_SW = 'SW';
    /**
     * Constant for value 'SB'
     * @return string 'SB'
     */
    const VALUE_SB = 'SB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BR
     * @uses self::VALUE_BL
     * @uses self::VALUE_HX
     * @uses self::VALUE_CI
     * @uses self::VALUE_SW
     * @uses self::VALUE_SB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BR,
            self::VALUE_BL,
            self::VALUE_HX,
            self::VALUE_CI,
            self::VALUE_SW,
            self::VALUE_SB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
