<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packagePriceData StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class PackagePriceData extends AbstractStructBase
{
    /**
     * The applicablePromos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\ExternalPromo[]
     */
    public $applicablePromos;
    /**
     * The discountTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountTotal;
    /**
     * The feeTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $feeTotal;
    /**
     * The markupTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $markupTotal;
    /**
     * The merchandiseTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $merchandiseTotal;
    /**
     * The orderCouponCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderCouponCode;
    /**
     * The overallHeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $overallHeight;
    /**
     * The overallSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overallSize;
    /**
     * The overallWidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $overallWidth;
    /**
     * The oversizedShipping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $oversizedShipping;
    /**
     * The promotionTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $promotionTotal;
    /**
     * The wholesaleTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $wholesaleTotal;
    /**
     * Constructor method for packagePriceData
     * @uses PackagePriceData::setApplicablePromos()
     * @uses PackagePriceData::setDiscountTotal()
     * @uses PackagePriceData::setFeeTotal()
     * @uses PackagePriceData::setMarkupTotal()
     * @uses PackagePriceData::setMerchandiseTotal()
     * @uses PackagePriceData::setOrderCouponCode()
     * @uses PackagePriceData::setOverallHeight()
     * @uses PackagePriceData::setOverallSize()
     * @uses PackagePriceData::setOverallWidth()
     * @uses PackagePriceData::setOversizedShipping()
     * @uses PackagePriceData::setPromotionTotal()
     * @uses PackagePriceData::setWholesaleTotal()
     * @param \GraphikDimensions\StructType\ExternalPromo[] $applicablePromos
     * @param float $discountTotal
     * @param float $feeTotal
     * @param float $markupTotal
     * @param float $merchandiseTotal
     * @param string $orderCouponCode
     * @param float $overallHeight
     * @param string $overallSize
     * @param float $overallWidth
     * @param float $oversizedShipping
     * @param float $promotionTotal
     * @param float $wholesaleTotal
     */
    public function __construct(array $applicablePromos = array(), $discountTotal = null, $feeTotal = null, $markupTotal = null, $merchandiseTotal = null, $orderCouponCode = null, $overallHeight = null, $overallSize = null, $overallWidth = null, $oversizedShipping = null, $promotionTotal = null, $wholesaleTotal = null)
    {
        $this
            ->setApplicablePromos($applicablePromos)
            ->setDiscountTotal($discountTotal)
            ->setFeeTotal($feeTotal)
            ->setMarkupTotal($markupTotal)
            ->setMerchandiseTotal($merchandiseTotal)
            ->setOrderCouponCode($orderCouponCode)
            ->setOverallHeight($overallHeight)
            ->setOverallSize($overallSize)
            ->setOverallWidth($overallWidth)
            ->setOversizedShipping($oversizedShipping)
            ->setPromotionTotal($promotionTotal)
            ->setWholesaleTotal($wholesaleTotal);
    }
    /**
     * Get applicablePromos value
     * @return \GraphikDimensions\StructType\ExternalPromo[]|null
     */
    public function getApplicablePromos()
    {
        return $this->applicablePromos;
    }
    /**
     * Set applicablePromos value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalPromo[] $applicablePromos
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setApplicablePromos(array $applicablePromos = array())
    {
        foreach ($applicablePromos as $packagePriceDataApplicablePromosItem) {
            // validation for constraint: itemType
            if (!$packagePriceDataApplicablePromosItem instanceof \GraphikDimensions\StructType\ExternalPromo) {
                throw new \InvalidArgumentException(sprintf('The applicablePromos property can only contain items of \GraphikDimensions\StructType\ExternalPromo, "%s" given', is_object($packagePriceDataApplicablePromosItem) ? get_class($packagePriceDataApplicablePromosItem) : gettype($packagePriceDataApplicablePromosItem)), __LINE__);
            }
        }
        $this->applicablePromos = $applicablePromos;
        return $this;
    }
    /**
     * Add item to applicablePromos value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalPromo $item
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function addToApplicablePromos(\GraphikDimensions\StructType\ExternalPromo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ExternalPromo) {
            throw new \InvalidArgumentException(sprintf('The applicablePromos property can only contain items of \GraphikDimensions\StructType\ExternalPromo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->applicablePromos[] = $item;
        return $this;
    }
    /**
     * Get discountTotal value
     * @return float|null
     */
    public function getDiscountTotal()
    {
        return $this->discountTotal;
    }
    /**
     * Set discountTotal value
     * @param float $discountTotal
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setDiscountTotal($discountTotal = null)
    {
        $this->discountTotal = $discountTotal;
        return $this;
    }
    /**
     * Get feeTotal value
     * @return float|null
     */
    public function getFeeTotal()
    {
        return $this->feeTotal;
    }
    /**
     * Set feeTotal value
     * @param float $feeTotal
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setFeeTotal($feeTotal = null)
    {
        $this->feeTotal = $feeTotal;
        return $this;
    }
    /**
     * Get markupTotal value
     * @return float|null
     */
    public function getMarkupTotal()
    {
        return $this->markupTotal;
    }
    /**
     * Set markupTotal value
     * @param float $markupTotal
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setMarkupTotal($markupTotal = null)
    {
        $this->markupTotal = $markupTotal;
        return $this;
    }
    /**
     * Get merchandiseTotal value
     * @return float|null
     */
    public function getMerchandiseTotal()
    {
        return $this->merchandiseTotal;
    }
    /**
     * Set merchandiseTotal value
     * @param float $merchandiseTotal
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setMerchandiseTotal($merchandiseTotal = null)
    {
        $this->merchandiseTotal = $merchandiseTotal;
        return $this;
    }
    /**
     * Get orderCouponCode value
     * @return string|null
     */
    public function getOrderCouponCode()
    {
        return $this->orderCouponCode;
    }
    /**
     * Set orderCouponCode value
     * @param string $orderCouponCode
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setOrderCouponCode($orderCouponCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderCouponCode) && !is_string($orderCouponCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderCouponCode)), __LINE__);
        }
        $this->orderCouponCode = $orderCouponCode;
        return $this;
    }
    /**
     * Get overallHeight value
     * @return float|null
     */
    public function getOverallHeight()
    {
        return $this->overallHeight;
    }
    /**
     * Set overallHeight value
     * @param float $overallHeight
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setOverallHeight($overallHeight = null)
    {
        $this->overallHeight = $overallHeight;
        return $this;
    }
    /**
     * Get overallSize value
     * @return string|null
     */
    public function getOverallSize()
    {
        return $this->overallSize;
    }
    /**
     * Set overallSize value
     * @param string $overallSize
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setOverallSize($overallSize = null)
    {
        // validation for constraint: string
        if (!is_null($overallSize) && !is_string($overallSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallSize)), __LINE__);
        }
        $this->overallSize = $overallSize;
        return $this;
    }
    /**
     * Get overallWidth value
     * @return float|null
     */
    public function getOverallWidth()
    {
        return $this->overallWidth;
    }
    /**
     * Set overallWidth value
     * @param float $overallWidth
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setOverallWidth($overallWidth = null)
    {
        $this->overallWidth = $overallWidth;
        return $this;
    }
    /**
     * Get oversizedShipping value
     * @return float|null
     */
    public function getOversizedShipping()
    {
        return $this->oversizedShipping;
    }
    /**
     * Set oversizedShipping value
     * @param float $oversizedShipping
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setOversizedShipping($oversizedShipping = null)
    {
        $this->oversizedShipping = $oversizedShipping;
        return $this;
    }
    /**
     * Get promotionTotal value
     * @return float|null
     */
    public function getPromotionTotal()
    {
        return $this->promotionTotal;
    }
    /**
     * Set promotionTotal value
     * @param float $promotionTotal
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setPromotionTotal($promotionTotal = null)
    {
        $this->promotionTotal = $promotionTotal;
        return $this;
    }
    /**
     * Get wholesaleTotal value
     * @return float|null
     */
    public function getWholesaleTotal()
    {
        return $this->wholesaleTotal;
    }
    /**
     * Set wholesaleTotal value
     * @param float $wholesaleTotal
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public function setWholesaleTotal($wholesaleTotal = null)
    {
        $this->wholesaleTotal = $wholesaleTotal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\PackagePriceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
