<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalMedia StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class ExternalMedia extends AbstractStructBase
{
    /**
     * The mediaType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mediaType;
    /**
     * The mimeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mimeType;
    /**
     * The rootSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rootSku;
    /**
     * The uri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $uri;
    /**
     * Constructor method for externalMedia
     * @uses ExternalMedia::setMediaType()
     * @uses ExternalMedia::setMimeType()
     * @uses ExternalMedia::setRootSku()
     * @uses ExternalMedia::setUri()
     * @param string $mediaType
     * @param string $mimeType
     * @param string $rootSku
     * @param string $uri
     */
    public function __construct($mediaType = null, $mimeType = null, $rootSku = null, $uri = null)
    {
        $this
            ->setMediaType($mediaType)
            ->setMimeType($mimeType)
            ->setRootSku($rootSku)
            ->setUri($uri);
    }
    /**
     * Get mediaType value
     * @return string|null
     */
    public function getMediaType()
    {
        return $this->mediaType;
    }
    /**
     * Set mediaType value
     * @param string $mediaType
     * @return \GraphikDimensions\StructType\ExternalMedia
     */
    public function setMediaType($mediaType = null)
    {
        // validation for constraint: string
        if (!is_null($mediaType) && !is_string($mediaType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mediaType)), __LINE__);
        }
        $this->mediaType = $mediaType;
        return $this;
    }
    /**
     * Get mimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Set mimeType value
     * @param string $mimeType
     * @return \GraphikDimensions\StructType\ExternalMedia
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mimeType)), __LINE__);
        }
        $this->mimeType = $mimeType;
        return $this;
    }
    /**
     * Get rootSku value
     * @return string|null
     */
    public function getRootSku()
    {
        return $this->rootSku;
    }
    /**
     * Set rootSku value
     * @param string $rootSku
     * @return \GraphikDimensions\StructType\ExternalMedia
     */
    public function setRootSku($rootSku = null)
    {
        // validation for constraint: string
        if (!is_null($rootSku) && !is_string($rootSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rootSku)), __LINE__);
        }
        $this->rootSku = $rootSku;
        return $this;
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \GraphikDimensions\StructType\ExternalMedia
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\ExternalMedia
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
