<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for condorFramePackage StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class CondorFramePackage extends FramePackage
{
    /**
     * The customProductList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GraphikDimensions\StructType\CustomProduct[]
     */
    public $customProductList;
    /**
     * Constructor method for condorFramePackage
     * @uses CondorFramePackage::setCustomProductList()
     * @param \GraphikDimensions\StructType\CustomProduct[] $customProductList
     */
    public function __construct(array $customProductList = array())
    {
        $this
            ->setCustomProductList($customProductList);
    }
    /**
     * Get customProductList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GraphikDimensions\StructType\CustomProduct[]|null
     */
    public function getCustomProductList()
    {
        return isset($this->customProductList) ? $this->customProductList : null;
    }
    /**
     * Set customProductList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\CustomProduct[] $customProductList
     * @return \GraphikDimensions\StructType\CondorFramePackage
     */
    public function setCustomProductList(array $customProductList = array())
    {
        foreach ($customProductList as $condorFramePackageCustomProductListItem) {
            // validation for constraint: itemType
            if (!$condorFramePackageCustomProductListItem instanceof \GraphikDimensions\StructType\CustomProduct) {
                throw new \InvalidArgumentException(sprintf('The customProductList property can only contain items of \GraphikDimensions\StructType\CustomProduct, "%s" given', is_object($condorFramePackageCustomProductListItem) ? get_class($condorFramePackageCustomProductListItem) : gettype($condorFramePackageCustomProductListItem)), __LINE__);
            }
        }
        if (is_null($customProductList) || (is_array($customProductList) && empty($customProductList))) {
            unset($this->customProductList);
        } else {
            $this->customProductList = $customProductList;
        }
        return $this;
    }
    /**
     * Add item to customProductList value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\CustomProduct $item
     * @return \GraphikDimensions\StructType\CondorFramePackage
     */
    public function addToCustomProductList(\GraphikDimensions\StructType\CustomProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\CustomProduct) {
            throw new \InvalidArgumentException(sprintf('The customProductList property can only contain items of \GraphikDimensions\StructType\CustomProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customProductList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\CondorFramePackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
