<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addProductToPackage StructType
 * Meta informations extracted from the WSDL
 * - type: tns:addProductToPackage
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class AddProductToPackage extends AbstractStructBase
{
    /**
     * The userAccessCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userAccessCode;
    /**
     * The packageId
     * @var int
     */
    public $packageId;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\ExternalProduct
     */
    public $product;
    /**
     * Constructor method for addProductToPackage
     * @uses AddProductToPackage::setUserAccessCode()
     * @uses AddProductToPackage::setPackageId()
     * @uses AddProductToPackage::setProduct()
     * @param string $userAccessCode
     * @param int $packageId
     * @param \GraphikDimensions\StructType\ExternalProduct $product
     */
    public function __construct($userAccessCode = null, $packageId = null, \GraphikDimensions\StructType\ExternalProduct $product = null)
    {
        $this
            ->setUserAccessCode($userAccessCode)
            ->setPackageId($packageId)
            ->setProduct($product);
    }
    /**
     * Get userAccessCode value
     * @return string|null
     */
    public function getUserAccessCode()
    {
        return $this->userAccessCode;
    }
    /**
     * Set userAccessCode value
     * @param string $userAccessCode
     * @return \GraphikDimensions\StructType\AddProductToPackage
     */
    public function setUserAccessCode($userAccessCode = null)
    {
        // validation for constraint: string
        if (!is_null($userAccessCode) && !is_string($userAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userAccessCode)), __LINE__);
        }
        $this->userAccessCode = $userAccessCode;
        return $this;
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \GraphikDimensions\StructType\AddProductToPackage
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !is_numeric($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageId)), __LINE__);
        }
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get product value
     * @return \GraphikDimensions\StructType\ExternalProduct|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \GraphikDimensions\StructType\ExternalProduct $product
     * @return \GraphikDimensions\StructType\AddProductToPackage
     */
    public function setProduct(\GraphikDimensions\StructType\ExternalProduct $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\AddProductToPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
