<?php

namespace GraphikDimensions\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validate ServiceType
 * @subpackage Services
 * @date Generated 2017-02-10
 * @author https
 */
class Validate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named validatePaymentMethods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GraphikDimensions\StructType\ValidatePaymentMethods $parameters
     * @return \GraphikDimensions\StructType\ValidatePaymentMethodsResponse|bool
     */
    public function validatePaymentMethods(\GraphikDimensions\StructType\ValidatePaymentMethods $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->validatePaymentMethods($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GraphikDimensions\StructType\ValidatePaymentMethodsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
