<?php

namespace GraphikDimensions\EnumType;

/**
 * This class stands for mountTypes EnumType
 * @subpackage Enumerations
 * @date Generated 2017-02-10
 * @author https
 */
class MountTypes
{
    /**
     * Constant for value 'UC'
     * @return string 'UC'
     */
    const VALUE_UC = 'UC';
    /**
     * Constant for value 'MW'
     * @return string 'MW'
     */
    const VALUE_MW = 'MW';
    /**
     * Constant for value 'GW'
     * @return string 'GW'
     */
    const VALUE_GW = 'GW';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UC
     * @uses self::VALUE_MW
     * @uses self::VALUE_GW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UC,
            self::VALUE_MW,
            self::VALUE_GW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
