<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalPrePackage StructType
 * @subpackage Structs
 * @date Generated 2017-02-10
 * @author https
 */
class ExternalPrePackage extends PrintAndFramePackage
{
    /**
     * The borderColor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $borderColor;
    /**
     * The bordertype
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bordertype;
    /**
     * The canvas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\Canvas
     */
    public $canvas;
    /**
     * The imageHeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $imageHeight;
    /**
     * The imageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imageName;
    /**
     * The imageURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imageURL;
    /**
     * The imageWidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $imageWidth;
    /**
     * The packageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageId;
    /**
     * The packageSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packageSku;
    /**
     * The sizeMatToImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sizeMatToImage;
    /**
     * Constructor method for externalPrePackage
     * @uses ExternalPrePackage::setBorderColor()
     * @uses ExternalPrePackage::setBordertype()
     * @uses ExternalPrePackage::setCanvas()
     * @uses ExternalPrePackage::setImageHeight()
     * @uses ExternalPrePackage::setImageName()
     * @uses ExternalPrePackage::setImageURL()
     * @uses ExternalPrePackage::setImageWidth()
     * @uses ExternalPrePackage::setPackageId()
     * @uses ExternalPrePackage::setPackageSku()
     * @uses ExternalPrePackage::setSizeMatToImage()
     * @param string $borderColor
     * @param string $bordertype
     * @param \GraphikDimensions\StructType\Canvas $canvas
     * @param float $imageHeight
     * @param string $imageName
     * @param string $imageURL
     * @param float $imageWidth
     * @param int $packageId
     * @param string $packageSku
     * @param int $sizeMatToImage
     */
    public function __construct($borderColor = null, $bordertype = null, \GraphikDimensions\StructType\Canvas $canvas = null, $imageHeight = null, $imageName = null, $imageURL = null, $imageWidth = null, $packageId = null, $packageSku = null, $sizeMatToImage = null)
    {
        $this
            ->setBorderColor($borderColor)
            ->setBordertype($bordertype)
            ->setCanvas($canvas)
            ->setImageHeight($imageHeight)
            ->setImageName($imageName)
            ->setImageURL($imageURL)
            ->setImageWidth($imageWidth)
            ->setPackageId($packageId)
            ->setPackageSku($packageSku)
            ->setSizeMatToImage($sizeMatToImage);
    }
    /**
     * Get borderColor value
     * @return string|null
     */
    public function getBorderColor()
    {
        return $this->borderColor;
    }
    /**
     * Set borderColor value
     * @param string $borderColor
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setBorderColor($borderColor = null)
    {
        // validation for constraint: string
        if (!is_null($borderColor) && !is_string($borderColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($borderColor)), __LINE__);
        }
        $this->borderColor = $borderColor;
        return $this;
    }
    /**
     * Get bordertype value
     * @return string|null
     */
    public function getBordertype()
    {
        return $this->bordertype;
    }
    /**
     * Set bordertype value
     * @uses \GraphikDimensions\EnumType\BorderStyle::valueIsValid()
     * @uses \GraphikDimensions\EnumType\BorderStyle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bordertype
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setBordertype($bordertype = null)
    {
        // validation for constraint: enumeration
        if (!\GraphikDimensions\EnumType\BorderStyle::valueIsValid($bordertype)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bordertype, implode(', ', \GraphikDimensions\EnumType\BorderStyle::getValidValues())), __LINE__);
        }
        $this->bordertype = $bordertype;
        return $this;
    }
    /**
     * Get canvas value
     * @return \GraphikDimensions\StructType\Canvas|null
     */
    public function getCanvas()
    {
        return $this->canvas;
    }
    /**
     * Set canvas value
     * @param \GraphikDimensions\StructType\Canvas $canvas
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setCanvas(\GraphikDimensions\StructType\Canvas $canvas = null)
    {
        $this->canvas = $canvas;
        return $this;
    }
    /**
     * Get imageHeight value
     * @return float|null
     */
    public function getImageHeight()
    {
        return $this->imageHeight;
    }
    /**
     * Set imageHeight value
     * @param float $imageHeight
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setImageHeight($imageHeight = null)
    {
        $this->imageHeight = $imageHeight;
        return $this;
    }
    /**
     * Get imageName value
     * @return string|null
     */
    public function getImageName()
    {
        return $this->imageName;
    }
    /**
     * Set imageName value
     * @param string $imageName
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setImageName($imageName = null)
    {
        // validation for constraint: string
        if (!is_null($imageName) && !is_string($imageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageName)), __LINE__);
        }
        $this->imageName = $imageName;
        return $this;
    }
    /**
     * Get imageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->imageURL;
    }
    /**
     * Set imageURL value
     * @param string $imageURL
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageURL)), __LINE__);
        }
        $this->imageURL = $imageURL;
        return $this;
    }
    /**
     * Get imageWidth value
     * @return float|null
     */
    public function getImageWidth()
    {
        return $this->imageWidth;
    }
    /**
     * Set imageWidth value
     * @param float $imageWidth
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setImageWidth($imageWidth = null)
    {
        $this->imageWidth = $imageWidth;
        return $this;
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !is_numeric($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageId)), __LINE__);
        }
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get packageSku value
     * @return string|null
     */
    public function getPackageSku()
    {
        return $this->packageSku;
    }
    /**
     * Set packageSku value
     * @param string $packageSku
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setPackageSku($packageSku = null)
    {
        // validation for constraint: string
        if (!is_null($packageSku) && !is_string($packageSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageSku)), __LINE__);
        }
        $this->packageSku = $packageSku;
        return $this;
    }
    /**
     * Get sizeMatToImage value
     * @return int|null
     */
    public function getSizeMatToImage()
    {
        return $this->sizeMatToImage;
    }
    /**
     * Set sizeMatToImage value
     * @param int $sizeMatToImage
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public function setSizeMatToImage($sizeMatToImage = null)
    {
        // validation for constraint: int
        if (!is_null($sizeMatToImage) && !is_numeric($sizeMatToImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sizeMatToImage)), __LINE__);
        }
        $this->sizeMatToImage = $sizeMatToImage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\ExternalPrePackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
