<?php

namespace GraphikDimensions\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prepare ServiceType
 * @subpackage Services
 * @date Generated 2017-02-10
 * @author https
 */
class Prepare extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named prepareOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GraphikDimensions\StructType\PrepareOrder $parameters
     * @return \GraphikDimensions\StructType\PrepareOrderResponse|bool
     */
    public function prepareOrder(\GraphikDimensions\StructType\PrepareOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->prepareOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GraphikDimensions\StructType\PrepareOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
