<?php

namespace GraphikDimensions\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @date Generated 2017-02-10
 * @author https
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getOrderStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GraphikDimensions\StructType\GetOrderStatus $parameters
     * @return \GraphikDimensions\StructType\GetOrderStatusResponse|bool
     */
    public function getOrderStatus(\GraphikDimensions\StructType\GetOrderStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrderStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderByCustomerName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GraphikDimensions\StructType\GetOrderByCustomerName $parameters
     * @return \GraphikDimensions\StructType\GetOrderByCustomerNameResponse|bool
     */
    public function getOrderByCustomerName(\GraphikDimensions\StructType\GetOrderByCustomerName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrderByCustomerName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrderStatusHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GraphikDimensions\StructType\GetOrderStatusHistory $parameters
     * @return \GraphikDimensions\StructType\GetOrderStatusHistoryResponse|bool
     */
    public function getOrderStatusHistory(\GraphikDimensions\StructType\GetOrderStatusHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrderStatusHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GraphikDimensions\StructType\GetOrderByCustomerNameResponse|\GraphikDimensions\StructType\GetOrderStatusHistoryResponse|\GraphikDimensions\StructType\GetOrderStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
