<?php

namespace GraphikDimensions\EnumType;

/**
 * This class stands for priceClassifications EnumType
 * @subpackage Enumerations
 * @date Generated 2017-02-10
 * @author https
 */
class PriceClassifications
{
    /**
     * Constant for value 'FEE'
     * @return string 'FEE'
     */
    const VALUE_FEE = 'FEE';
    /**
     * Constant for value 'MERCHANDISE'
     * @return string 'MERCHANDISE'
     */
    const VALUE_MERCHANDISE = 'MERCHANDISE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FEE
     * @uses self::VALUE_MERCHANDISE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FEE,
            self::VALUE_MERCHANDISE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
