<?php

namespace GraphikDimensions;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'externalCriteria' => '\\GraphikDimensions\\StructType\\ExternalCriteria',
            'substrate' => '\\GraphikDimensions\\StructType\\Substrate',
            'dimensionedExternalProduct' => '\\GraphikDimensions\\StructType\\DimensionedExternalProduct',
            'externalProduct' => '\\GraphikDimensions\\StructType\\ExternalProduct',
            'dimension' => '\\GraphikDimensions\\StructType\\Dimension',
            'complexDescription' => '\\GraphikDimensions\\StructType\\ComplexDescription',
            'externalProductAttributeGroup' => '\\GraphikDimensions\\StructType\\ExternalProductAttributeGroup',
            'externalProductAttribute' => '\\GraphikDimensions\\StructType\\ExternalProductAttribute',
            'externalProductGroup' => '\\GraphikDimensions\\StructType\\ExternalProductGroup',
            'externalProductType' => '\\GraphikDimensions\\StructType\\ExternalProductType',
            'externalProductTypeDef' => '\\GraphikDimensions\\StructType\\ExternalProductTypeDef',
            'priceData' => '\\GraphikDimensions\\StructType\\PriceData',
            'externalPromo' => '\\GraphikDimensions\\StructType\\ExternalPromo',
            'externalCriteriaGroup' => '\\GraphikDimensions\\StructType\\ExternalCriteriaGroup',
            'externalPriceTable' => '\\GraphikDimensions\\StructType\\ExternalPriceTable',
            'priceMapping' => '\\GraphikDimensions\\StructType\\PriceMapping',
            'sku' => '\\GraphikDimensions\\StructType\\Sku',
            'externalUser' => '\\GraphikDimensions\\StructType\\ExternalUser',
            'templateVariableValue' => '\\GraphikDimensions\\StructType\\TemplateVariableValue',
            'giftData' => '\\GraphikDimensions\\StructType\\GiftData',
            'externalOrderConfirmation' => '\\GraphikDimensions\\StructType\\ExternalOrderConfirmation',
            'matBoard' => '\\GraphikDimensions\\StructType\\MatBoard',
            'mat' => '\\GraphikDimensions\\StructType\\Mat',
            'fillet' => '\\GraphikDimensions\\StructType\\Fillet',
            'frame' => '\\GraphikDimensions\\StructType\\Frame',
            'oversizedFee' => '\\GraphikDimensions\\StructType\\OversizedFee',
            'vGroove' => '\\GraphikDimensions\\StructType\\VGroove',
            'customProduct' => '\\GraphikDimensions\\StructType\\CustomProduct',
            'paymentMethod' => '\\GraphikDimensions\\StructType\\PaymentMethod',
            'externalProductPackage' => '\\GraphikDimensions\\StructType\\ExternalProductPackage',
            'fee' => '\\GraphikDimensions\\StructType\\Fee',
            'packagePriceData' => '\\GraphikDimensions\\StructType\\PackagePriceData',
            'glazing' => '\\GraphikDimensions\\StructType\\Glazing',
            'boardPackage' => '\\GraphikDimensions\\StructType\\BoardPackage',
            'framePackage' => '\\GraphikDimensions\\StructType\\FramePackage',
            'backing' => '\\GraphikDimensions\\StructType\\Backing',
            'board' => '\\GraphikDimensions\\StructType\\Board',
            'finishKit' => '\\GraphikDimensions\\StructType\\FinishKit',
            'finishingOption' => '\\GraphikDimensions\\StructType\\FinishingOption',
            'floatMount' => '\\GraphikDimensions\\StructType\\FloatMount',
            'image' => '\\GraphikDimensions\\StructType\\Image',
            'externalMedia' => '\\GraphikDimensions\\StructType\\ExternalMedia',
            'printJob' => '\\GraphikDimensions\\StructType\\PrintJob',
            'template' => '\\GraphikDimensions\\StructType\\Template',
            'templateVariable' => '\\GraphikDimensions\\StructType\\TemplateVariable',
            'liner' => '\\GraphikDimensions\\StructType\\Liner',
            'mountBoard' => '\\GraphikDimensions\\StructType\\MountBoard',
            'nameplate' => '\\GraphikDimensions\\StructType\\Nameplate',
            'raisedMat' => '\\GraphikDimensions\\StructType\\RaisedMat',
            'reverseBevelCut' => '\\GraphikDimensions\\StructType\\ReverseBevelCut',
            'channel' => '\\GraphikDimensions\\StructType\\Channel',
            'giftCertificate' => '\\GraphikDimensions\\StructType\\GiftCertificate',
            'giftCard' => '\\GraphikDimensions\\StructType\\GiftCard',
            'printOnlyPackage' => '\\GraphikDimensions\\StructType\\PrintOnlyPackage',
            'mirror' => '\\GraphikDimensions\\StructType\\Mirror',
            'shadowBoxPackage' => '\\GraphikDimensions\\StructType\\ShadowBoxPackage',
            'externalOrderLineItem' => '\\GraphikDimensions\\StructType\\ExternalOrderLineItem',
            'channelItemId' => '\\GraphikDimensions\\StructType\\ChannelItemId',
            'channelSpecificIdentifier' => '\\GraphikDimensions\\StructType\\ChannelSpecificIdentifier',
            'costData' => '\\GraphikDimensions\\StructType\\CostData',
            'message' => '\\GraphikDimensions\\StructType\\Message',
            'assemblyFee' => '\\GraphikDimensions\\StructType\\AssemblyFee',
            'cash' => '\\GraphikDimensions\\StructType\\Cash',
            'externalOrder' => '\\GraphikDimensions\\StructType\\ExternalOrder',
            'channelOrderId' => '\\GraphikDimensions\\StructType\\ChannelOrderId',
            'externalCustomer' => '\\GraphikDimensions\\StructType\\ExternalCustomer',
            'externalAddress' => '\\GraphikDimensions\\StructType\\ExternalAddress',
            'shippingData' => '\\GraphikDimensions\\StructType\\ShippingData',
            'internationalShipping' => '\\GraphikDimensions\\StructType\\InternationalShipping',
            'otherUsShipping' => '\\GraphikDimensions\\StructType\\OtherUsShipping',
            'shippingCostData' => '\\GraphikDimensions\\StructType\\ShippingCostData',
            'canvas' => '\\GraphikDimensions\\StructType\\Canvas',
            'creditCard' => '\\GraphikDimensions\\StructType\\CreditCard',
            'documentPrintJob' => '\\GraphikDimensions\\StructType\\DocumentPrintJob',
            'printAndFramePackage' => '\\GraphikDimensions\\StructType\\PrintAndFramePackage',
            'stretcherBar' => '\\GraphikDimensions\\StructType\\StretcherBar',
            'canvasWrapPackage' => '\\GraphikDimensions\\StructType\\CanvasWrapPackage',
            'mirrorPackage' => '\\GraphikDimensions\\StructType\\MirrorPackage',
            'payPal' => '\\GraphikDimensions\\StructType\\PayPal',
            'merchantAccount' => '\\GraphikDimensions\\StructType\\MerchantAccount',
            'externalPrePackage' => '\\GraphikDimensions\\StructType\\ExternalPrePackage',
            'collection' => '\\GraphikDimensions\\StructType\\Collection',
            'condorFramePackage' => '\\GraphikDimensions\\StructType\\CondorFramePackage',
            'paper' => '\\GraphikDimensions\\StructType\\Paper',
            'ragMat' => '\\GraphikDimensions\\StructType\\RagMat',
            'check' => '\\GraphikDimensions\\StructType\\Check',
            'externalOrderStatus' => '\\GraphikDimensions\\StructType\\ExternalOrderStatus',
            'ServiceException' => '\\GraphikDimensions\\StructType\\ServiceException',
            'getOrderStatus' => '\\GraphikDimensions\\StructType\\GetOrderStatus',
            'getOrderStatusResponse' => '\\GraphikDimensions\\StructType\\GetOrderStatusResponse',
            'introduceExternalObjects' => '\\GraphikDimensions\\StructType\\IntroduceExternalObjects',
            'introduceExternalObjectsResponse' => '\\GraphikDimensions\\StructType\\IntroduceExternalObjectsResponse',
            'processOrder' => '\\GraphikDimensions\\StructType\\ProcessOrder',
            'processOrderResponse' => '\\GraphikDimensions\\StructType\\ProcessOrderResponse',
            'prepareOrder' => '\\GraphikDimensions\\StructType\\PrepareOrder',
            'prepareOrderResponse' => '\\GraphikDimensions\\StructType\\PrepareOrderResponse',
            'addProductToPackage' => '\\GraphikDimensions\\StructType\\AddProductToPackage',
            'addProductToPackageResponse' => '\\GraphikDimensions\\StructType\\AddProductToPackageResponse',
            'setOrderStatus' => '\\GraphikDimensions\\StructType\\SetOrderStatus',
            'setOrderStatusResponse' => '\\GraphikDimensions\\StructType\\SetOrderStatusResponse',
            'validatePaymentMethods' => '\\GraphikDimensions\\StructType\\ValidatePaymentMethods',
            'validatePaymentMethodsResponse' => '\\GraphikDimensions\\StructType\\ValidatePaymentMethodsResponse',
            'createPackage' => '\\GraphikDimensions\\StructType\\CreatePackage',
            'createPackageResponse' => '\\GraphikDimensions\\StructType\\CreatePackageResponse',
            'removeProductFromPackage' => '\\GraphikDimensions\\StructType\\RemoveProductFromPackage',
            'removeProductFromPackageResponse' => '\\GraphikDimensions\\StructType\\RemoveProductFromPackageResponse',
            'createPrePackage' => '\\GraphikDimensions\\StructType\\CreatePrePackage',
            'createPrePackageResponse' => '\\GraphikDimensions\\StructType\\CreatePrePackageResponse',
            'processCoupon' => '\\GraphikDimensions\\StructType\\ProcessCoupon',
            'processCouponResponse' => '\\GraphikDimensions\\StructType\\ProcessCouponResponse',
            'processFramerOrder' => '\\GraphikDimensions\\StructType\\ProcessFramerOrder',
            'processFramerOrderResponse' => '\\GraphikDimensions\\StructType\\ProcessFramerOrderResponse',
            'getOrderByCustomerName' => '\\GraphikDimensions\\StructType\\GetOrderByCustomerName',
            'getOrderByCustomerNameResponse' => '\\GraphikDimensions\\StructType\\GetOrderByCustomerNameResponse',
            'getOrderStatusHistory' => '\\GraphikDimensions\\StructType\\GetOrderStatusHistory',
            'getOrderStatusHistoryResponse' => '\\GraphikDimensions\\StructType\\GetOrderStatusHistoryResponse',
        );
    }
}
