<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printOnlyPackage StructType
 * @subpackage Structs
 */
class PrintOnlyPackage extends ExternalProductPackage
{
    /**
     * The image
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Image
     */
    public $image;
    /**
     * The substrate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Substrate
     */
    public $substrate;
    /**
     * Constructor method for printOnlyPackage
     * @uses PrintOnlyPackage::setImage()
     * @uses PrintOnlyPackage::setSubstrate()
     * @param \StructType\Image $image
     * @param \StructType\Substrate $substrate
     */
    public function __construct(\StructType\Image $image = null, \StructType\Substrate $substrate = null)
    {
        $this
            ->setImage($image)
            ->setSubstrate($substrate);
    }
    /**
     * Get image value
     * @return \StructType\Image|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param \StructType\Image $image
     * @return \StructType\PrintOnlyPackage
     */
    public function setImage(\StructType\Image $image = null)
    {
        $this->image = $image;
        return $this;
    }
    /**
     * Get substrate value
     * @return \StructType\Substrate|null
     */
    public function getSubstrate()
    {
        return $this->substrate;
    }
    /**
     * Set substrate value
     * @param \StructType\Substrate $substrate
     * @return \StructType\PrintOnlyPackage
     */
    public function setSubstrate(\StructType\Substrate $substrate = null)
    {
        $this->substrate = $substrate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintOnlyPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
