<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for priceData StructType
 * @subpackage Structs
 */
class PriceData extends AbstractStructBase
{
    /**
     * The applicablePromos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalPromo[]
     */
    public $applicablePromos;
    /**
     * The authorizedPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $authorizedPrice;
    /**
     * The discountAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAmount;
    /**
     * The discountedPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountedPrice;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The markUpPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $markUpPrice;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The orderCouponCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderCouponCode;
    /**
     * The oversizedShipping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $oversizedShipping;
    /**
     * The priceClassification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priceClassification;
    /**
     * The priceTables
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalPriceTable[]
     */
    public $priceTables;
    /**
     * The priceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priceType;
    /**
     * The pricingGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pricingGroupId;
    /**
     * The staticPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $staticPrice;
    /**
     * The wholesalePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $wholesalePrice;
    /**
     * Constructor method for priceData
     * @uses PriceData::setApplicablePromos()
     * @uses PriceData::setAuthorizedPrice()
     * @uses PriceData::setDiscountAmount()
     * @uses PriceData::setDiscountedPrice()
     * @uses PriceData::setId()
     * @uses PriceData::setMarkUpPrice()
     * @uses PriceData::setMessage()
     * @uses PriceData::setOrderCouponCode()
     * @uses PriceData::setOversizedShipping()
     * @uses PriceData::setPriceClassification()
     * @uses PriceData::setPriceTables()
     * @uses PriceData::setPriceType()
     * @uses PriceData::setPricingGroupId()
     * @uses PriceData::setStaticPrice()
     * @uses PriceData::setWholesalePrice()
     * @param \StructType\ExternalPromo[] $applicablePromos
     * @param float $authorizedPrice
     * @param float $discountAmount
     * @param float $discountedPrice
     * @param int $id
     * @param float $markUpPrice
     * @param string $message
     * @param string $orderCouponCode
     * @param float $oversizedShipping
     * @param string $priceClassification
     * @param \StructType\ExternalPriceTable[] $priceTables
     * @param string $priceType
     * @param int $pricingGroupId
     * @param float $staticPrice
     * @param float $wholesalePrice
     */
    public function __construct(array $applicablePromos = array(), $authorizedPrice = null, $discountAmount = null, $discountedPrice = null, $id = null, $markUpPrice = null, $message = null, $orderCouponCode = null, $oversizedShipping = null, $priceClassification = null, array $priceTables = array(), $priceType = null, $pricingGroupId = null, $staticPrice = null, $wholesalePrice = null)
    {
        $this
            ->setApplicablePromos($applicablePromos)
            ->setAuthorizedPrice($authorizedPrice)
            ->setDiscountAmount($discountAmount)
            ->setDiscountedPrice($discountedPrice)
            ->setId($id)
            ->setMarkUpPrice($markUpPrice)
            ->setMessage($message)
            ->setOrderCouponCode($orderCouponCode)
            ->setOversizedShipping($oversizedShipping)
            ->setPriceClassification($priceClassification)
            ->setPriceTables($priceTables)
            ->setPriceType($priceType)
            ->setPricingGroupId($pricingGroupId)
            ->setStaticPrice($staticPrice)
            ->setWholesalePrice($wholesalePrice);
    }
    /**
     * Get applicablePromos value
     * @return \StructType\ExternalPromo[]|null
     */
    public function getApplicablePromos()
    {
        return $this->applicablePromos;
    }
    /**
     * Set applicablePromos value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalPromo[] $applicablePromos
     * @return \StructType\PriceData
     */
    public function setApplicablePromos(array $applicablePromos = array())
    {
        foreach ($applicablePromos as $priceDataApplicablePromosItem) {
            // validation for constraint: itemType
            if (!$priceDataApplicablePromosItem instanceof \StructType\ExternalPromo) {
                throw new \InvalidArgumentException(sprintf('The applicablePromos property can only contain items of \StructType\ExternalPromo, "%s" given', is_object($priceDataApplicablePromosItem) ? get_class($priceDataApplicablePromosItem) : gettype($priceDataApplicablePromosItem)), __LINE__);
            }
        }
        $this->applicablePromos = $applicablePromos;
        return $this;
    }
    /**
     * Add item to applicablePromos value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalPromo $item
     * @return \StructType\PriceData
     */
    public function addToApplicablePromos(\StructType\ExternalPromo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalPromo) {
            throw new \InvalidArgumentException(sprintf('The applicablePromos property can only contain items of \StructType\ExternalPromo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->applicablePromos[] = $item;
        return $this;
    }
    /**
     * Get authorizedPrice value
     * @return float|null
     */
    public function getAuthorizedPrice()
    {
        return $this->authorizedPrice;
    }
    /**
     * Set authorizedPrice value
     * @param float $authorizedPrice
     * @return \StructType\PriceData
     */
    public function setAuthorizedPrice($authorizedPrice = null)
    {
        $this->authorizedPrice = $authorizedPrice;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param float $discountAmount
     * @return \StructType\PriceData
     */
    public function setDiscountAmount($discountAmount = null)
    {
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get discountedPrice value
     * @return float|null
     */
    public function getDiscountedPrice()
    {
        return $this->discountedPrice;
    }
    /**
     * Set discountedPrice value
     * @param float $discountedPrice
     * @return \StructType\PriceData
     */
    public function setDiscountedPrice($discountedPrice = null)
    {
        $this->discountedPrice = $discountedPrice;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\PriceData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get markUpPrice value
     * @return float|null
     */
    public function getMarkUpPrice()
    {
        return $this->markUpPrice;
    }
    /**
     * Set markUpPrice value
     * @param float $markUpPrice
     * @return \StructType\PriceData
     */
    public function setMarkUpPrice($markUpPrice = null)
    {
        $this->markUpPrice = $markUpPrice;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\PriceData
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get orderCouponCode value
     * @return string|null
     */
    public function getOrderCouponCode()
    {
        return $this->orderCouponCode;
    }
    /**
     * Set orderCouponCode value
     * @param string $orderCouponCode
     * @return \StructType\PriceData
     */
    public function setOrderCouponCode($orderCouponCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderCouponCode) && !is_string($orderCouponCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderCouponCode)), __LINE__);
        }
        $this->orderCouponCode = $orderCouponCode;
        return $this;
    }
    /**
     * Get oversizedShipping value
     * @return float|null
     */
    public function getOversizedShipping()
    {
        return $this->oversizedShipping;
    }
    /**
     * Set oversizedShipping value
     * @param float $oversizedShipping
     * @return \StructType\PriceData
     */
    public function setOversizedShipping($oversizedShipping = null)
    {
        $this->oversizedShipping = $oversizedShipping;
        return $this;
    }
    /**
     * Get priceClassification value
     * @return string|null
     */
    public function getPriceClassification()
    {
        return $this->priceClassification;
    }
    /**
     * Set priceClassification value
     * @uses \EnumType\PriceClassifications::valueIsValid()
     * @uses \EnumType\PriceClassifications::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceClassification
     * @return \StructType\PriceData
     */
    public function setPriceClassification($priceClassification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PriceClassifications::valueIsValid($priceClassification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priceClassification, implode(', ', \EnumType\PriceClassifications::getValidValues())), __LINE__);
        }
        $this->priceClassification = $priceClassification;
        return $this;
    }
    /**
     * Get priceTables value
     * @return \StructType\ExternalPriceTable[]|null
     */
    public function getPriceTables()
    {
        return $this->priceTables;
    }
    /**
     * Set priceTables value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalPriceTable[] $priceTables
     * @return \StructType\PriceData
     */
    public function setPriceTables(array $priceTables = array())
    {
        foreach ($priceTables as $priceDataPriceTablesItem) {
            // validation for constraint: itemType
            if (!$priceDataPriceTablesItem instanceof \StructType\ExternalPriceTable) {
                throw new \InvalidArgumentException(sprintf('The priceTables property can only contain items of \StructType\ExternalPriceTable, "%s" given', is_object($priceDataPriceTablesItem) ? get_class($priceDataPriceTablesItem) : gettype($priceDataPriceTablesItem)), __LINE__);
            }
        }
        $this->priceTables = $priceTables;
        return $this;
    }
    /**
     * Add item to priceTables value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalPriceTable $item
     * @return \StructType\PriceData
     */
    public function addToPriceTables(\StructType\ExternalPriceTable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalPriceTable) {
            throw new \InvalidArgumentException(sprintf('The priceTables property can only contain items of \StructType\ExternalPriceTable, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->priceTables[] = $item;
        return $this;
    }
    /**
     * Get priceType value
     * @return string|null
     */
    public function getPriceType()
    {
        return $this->priceType;
    }
    /**
     * Set priceType value
     * @param string $priceType
     * @return \StructType\PriceData
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: string
        if (!is_null($priceType) && !is_string($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceType)), __LINE__);
        }
        $this->priceType = $priceType;
        return $this;
    }
    /**
     * Get pricingGroupId value
     * @return int|null
     */
    public function getPricingGroupId()
    {
        return $this->pricingGroupId;
    }
    /**
     * Set pricingGroupId value
     * @param int $pricingGroupId
     * @return \StructType\PriceData
     */
    public function setPricingGroupId($pricingGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupId) && !is_numeric($pricingGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pricingGroupId)), __LINE__);
        }
        $this->pricingGroupId = $pricingGroupId;
        return $this;
    }
    /**
     * Get staticPrice value
     * @return float|null
     */
    public function getStaticPrice()
    {
        return $this->staticPrice;
    }
    /**
     * Set staticPrice value
     * @param float $staticPrice
     * @return \StructType\PriceData
     */
    public function setStaticPrice($staticPrice = null)
    {
        $this->staticPrice = $staticPrice;
        return $this;
    }
    /**
     * Get wholesalePrice value
     * @return float|null
     */
    public function getWholesalePrice()
    {
        return $this->wholesalePrice;
    }
    /**
     * Set wholesalePrice value
     * @param float $wholesalePrice
     * @return \StructType\PriceData
     */
    public function setWholesalePrice($wholesalePrice = null)
    {
        $this->wholesalePrice = $wholesalePrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
