<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for otherUsShipping StructType
 * @subpackage Structs
 */
class OtherUsShipping extends AbstractStructBase
{
    /**
     * The serviceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceCode;
    /**
     * The shippingAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingAmount;
    /**
     * The shippingMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingMethod;
    /**
     * Constructor method for otherUsShipping
     * @uses OtherUsShipping::setServiceCode()
     * @uses OtherUsShipping::setShippingAmount()
     * @uses OtherUsShipping::setShippingMethod()
     * @param string $serviceCode
     * @param float $shippingAmount
     * @param string $shippingMethod
     */
    public function __construct($serviceCode = null, $shippingAmount = null, $shippingMethod = null)
    {
        $this
            ->setServiceCode($serviceCode)
            ->setShippingAmount($shippingAmount)
            ->setShippingMethod($shippingMethod);
    }
    /**
     * Get serviceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->serviceCode;
    }
    /**
     * Set serviceCode value
     * @param string $serviceCode
     * @return \StructType\OtherUsShipping
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceCode)), __LINE__);
        }
        $this->serviceCode = $serviceCode;
        return $this;
    }
    /**
     * Get shippingAmount value
     * @return float|null
     */
    public function getShippingAmount()
    {
        return $this->shippingAmount;
    }
    /**
     * Set shippingAmount value
     * @param float $shippingAmount
     * @return \StructType\OtherUsShipping
     */
    public function setShippingAmount($shippingAmount = null)
    {
        $this->shippingAmount = $shippingAmount;
        return $this;
    }
    /**
     * Get shippingMethod value
     * @return string|null
     */
    public function getShippingMethod()
    {
        return $this->shippingMethod;
    }
    /**
     * Set shippingMethod value
     * @param string $shippingMethod
     * @return \StructType\OtherUsShipping
     */
    public function setShippingMethod($shippingMethod = null)
    {
        // validation for constraint: string
        if (!is_null($shippingMethod) && !is_string($shippingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippingMethod)), __LINE__);
        }
        $this->shippingMethod = $shippingMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OtherUsShipping
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
