<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalPromo StructType
 * @subpackage Structs
 */
class ExternalPromo extends AbstractStructBase
{
    /**
     * The addFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $addFee;
    /**
     * The applicablePhase
     * @var int
     */
    public $applicablePhase;
    /**
     * The appliedDiscount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $appliedDiscount;
    /**
     * The couponCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $couponCode;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The discountAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAmount;
    /**
     * The externalCriteriaGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalCriteriaGroup[]
     */
    public $externalCriteriaGroups;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The inactiveIndicator
     * @var int
     */
    public $inactiveIndicator;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The messageCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageCode;
    /**
     * The messageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageType;
    /**
     * The operatorType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operatorType;
    /**
     * The processType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $processType;
    /**
     * The promoType
     * @var int
     */
    public $promoType;
    /**
     * Constructor method for externalPromo
     * @uses ExternalPromo::setAddFee()
     * @uses ExternalPromo::setApplicablePhase()
     * @uses ExternalPromo::setAppliedDiscount()
     * @uses ExternalPromo::setCouponCode()
     * @uses ExternalPromo::setDescription()
     * @uses ExternalPromo::setDiscountAmount()
     * @uses ExternalPromo::setExternalCriteriaGroups()
     * @uses ExternalPromo::setId()
     * @uses ExternalPromo::setInactiveIndicator()
     * @uses ExternalPromo::setMessage()
     * @uses ExternalPromo::setMessageCode()
     * @uses ExternalPromo::setMessageType()
     * @uses ExternalPromo::setOperatorType()
     * @uses ExternalPromo::setProcessType()
     * @uses ExternalPromo::setPromoType()
     * @param float $addFee
     * @param int $applicablePhase
     * @param float $appliedDiscount
     * @param string $couponCode
     * @param string $description
     * @param float $discountAmount
     * @param \StructType\ExternalCriteriaGroup[] $externalCriteriaGroups
     * @param int $id
     * @param int $inactiveIndicator
     * @param string $message
     * @param string $messageCode
     * @param string $messageType
     * @param string $operatorType
     * @param string $processType
     * @param int $promoType
     */
    public function __construct($addFee = null, $applicablePhase = null, $appliedDiscount = null, $couponCode = null, $description = null, $discountAmount = null, array $externalCriteriaGroups = array(), $id = null, $inactiveIndicator = null, $message = null, $messageCode = null, $messageType = null, $operatorType = null, $processType = null, $promoType = null)
    {
        $this
            ->setAddFee($addFee)
            ->setApplicablePhase($applicablePhase)
            ->setAppliedDiscount($appliedDiscount)
            ->setCouponCode($couponCode)
            ->setDescription($description)
            ->setDiscountAmount($discountAmount)
            ->setExternalCriteriaGroups($externalCriteriaGroups)
            ->setId($id)
            ->setInactiveIndicator($inactiveIndicator)
            ->setMessage($message)
            ->setMessageCode($messageCode)
            ->setMessageType($messageType)
            ->setOperatorType($operatorType)
            ->setProcessType($processType)
            ->setPromoType($promoType);
    }
    /**
     * Get addFee value
     * @return float|null
     */
    public function getAddFee()
    {
        return $this->addFee;
    }
    /**
     * Set addFee value
     * @param float $addFee
     * @return \StructType\ExternalPromo
     */
    public function setAddFee($addFee = null)
    {
        $this->addFee = $addFee;
        return $this;
    }
    /**
     * Get applicablePhase value
     * @return int|null
     */
    public function getApplicablePhase()
    {
        return $this->applicablePhase;
    }
    /**
     * Set applicablePhase value
     * @param int $applicablePhase
     * @return \StructType\ExternalPromo
     */
    public function setApplicablePhase($applicablePhase = null)
    {
        // validation for constraint: int
        if (!is_null($applicablePhase) && !is_numeric($applicablePhase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($applicablePhase)), __LINE__);
        }
        $this->applicablePhase = $applicablePhase;
        return $this;
    }
    /**
     * Get appliedDiscount value
     * @return float|null
     */
    public function getAppliedDiscount()
    {
        return $this->appliedDiscount;
    }
    /**
     * Set appliedDiscount value
     * @param float $appliedDiscount
     * @return \StructType\ExternalPromo
     */
    public function setAppliedDiscount($appliedDiscount = null)
    {
        $this->appliedDiscount = $appliedDiscount;
        return $this;
    }
    /**
     * Get couponCode value
     * @return string|null
     */
    public function getCouponCode()
    {
        return $this->couponCode;
    }
    /**
     * Set couponCode value
     * @param string $couponCode
     * @return \StructType\ExternalPromo
     */
    public function setCouponCode($couponCode = null)
    {
        // validation for constraint: string
        if (!is_null($couponCode) && !is_string($couponCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($couponCode)), __LINE__);
        }
        $this->couponCode = $couponCode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ExternalPromo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param float $discountAmount
     * @return \StructType\ExternalPromo
     */
    public function setDiscountAmount($discountAmount = null)
    {
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get externalCriteriaGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalCriteriaGroup[]|null
     */
    public function getExternalCriteriaGroups()
    {
        return isset($this->externalCriteriaGroups) ? $this->externalCriteriaGroups : null;
    }
    /**
     * Set externalCriteriaGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalCriteriaGroup[] $externalCriteriaGroups
     * @return \StructType\ExternalPromo
     */
    public function setExternalCriteriaGroups(array $externalCriteriaGroups = array())
    {
        foreach ($externalCriteriaGroups as $externalPromoExternalCriteriaGroupsItem) {
            // validation for constraint: itemType
            if (!$externalPromoExternalCriteriaGroupsItem instanceof \StructType\ExternalCriteriaGroup) {
                throw new \InvalidArgumentException(sprintf('The externalCriteriaGroups property can only contain items of \StructType\ExternalCriteriaGroup, "%s" given', is_object($externalPromoExternalCriteriaGroupsItem) ? get_class($externalPromoExternalCriteriaGroupsItem) : gettype($externalPromoExternalCriteriaGroupsItem)), __LINE__);
            }
        }
        if (is_null($externalCriteriaGroups) || (is_array($externalCriteriaGroups) && empty($externalCriteriaGroups))) {
            unset($this->externalCriteriaGroups);
        } else {
            $this->externalCriteriaGroups = $externalCriteriaGroups;
        }
        return $this;
    }
    /**
     * Add item to externalCriteriaGroups value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalCriteriaGroup $item
     * @return \StructType\ExternalPromo
     */
    public function addToExternalCriteriaGroups(\StructType\ExternalCriteriaGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalCriteriaGroup) {
            throw new \InvalidArgumentException(sprintf('The externalCriteriaGroups property can only contain items of \StructType\ExternalCriteriaGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalCriteriaGroups[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ExternalPromo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get inactiveIndicator value
     * @return int|null
     */
    public function getInactiveIndicator()
    {
        return $this->inactiveIndicator;
    }
    /**
     * Set inactiveIndicator value
     * @param int $inactiveIndicator
     * @return \StructType\ExternalPromo
     */
    public function setInactiveIndicator($inactiveIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($inactiveIndicator) && !is_numeric($inactiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inactiveIndicator)), __LINE__);
        }
        $this->inactiveIndicator = $inactiveIndicator;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ExternalPromo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get messageCode value
     * @return string|null
     */
    public function getMessageCode()
    {
        return $this->messageCode;
    }
    /**
     * Set messageCode value
     * @param string $messageCode
     * @return \StructType\ExternalPromo
     */
    public function setMessageCode($messageCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageCode) && !is_string($messageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageCode)), __LINE__);
        }
        $this->messageCode = $messageCode;
        return $this;
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\ExternalPromo
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get operatorType value
     * @return string|null
     */
    public function getOperatorType()
    {
        return $this->operatorType;
    }
    /**
     * Set operatorType value
     * @uses \EnumType\OperatorTypes::valueIsValid()
     * @uses \EnumType\OperatorTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operatorType
     * @return \StructType\ExternalPromo
     */
    public function setOperatorType($operatorType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OperatorTypes::valueIsValid($operatorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operatorType, implode(', ', \EnumType\OperatorTypes::getValidValues())), __LINE__);
        }
        $this->operatorType = $operatorType;
        return $this;
    }
    /**
     * Get processType value
     * @return string|null
     */
    public function getProcessType()
    {
        return $this->processType;
    }
    /**
     * Set processType value
     * @param string $processType
     * @return \StructType\ExternalPromo
     */
    public function setProcessType($processType = null)
    {
        // validation for constraint: string
        if (!is_null($processType) && !is_string($processType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processType)), __LINE__);
        }
        $this->processType = $processType;
        return $this;
    }
    /**
     * Get promoType value
     * @return int|null
     */
    public function getPromoType()
    {
        return $this->promoType;
    }
    /**
     * Set promoType value
     * @param int $promoType
     * @return \StructType\ExternalPromo
     */
    public function setPromoType($promoType = null)
    {
        // validation for constraint: int
        if (!is_null($promoType) && !is_numeric($promoType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promoType)), __LINE__);
        }
        $this->promoType = $promoType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalPromo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
