<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalPriceTable StructType
 * @subpackage Structs
 */
class ExternalPriceTable extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The priceMappings
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PriceMapping[]
     */
    public $priceMappings;
    /**
     * The priceTableName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priceTableName;
    /**
     * The skus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Sku[]
     */
    public $skus;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * Constructor method for externalPriceTable
     * @uses ExternalPriceTable::setId()
     * @uses ExternalPriceTable::setPriceMappings()
     * @uses ExternalPriceTable::setPriceTableName()
     * @uses ExternalPriceTable::setSkus()
     * @uses ExternalPriceTable::setType()
     * @param int $id
     * @param \StructType\PriceMapping[] $priceMappings
     * @param string $priceTableName
     * @param \StructType\Sku[] $skus
     * @param string $type
     */
    public function __construct($id = null, array $priceMappings = array(), $priceTableName = null, array $skus = array(), $type = null)
    {
        $this
            ->setId($id)
            ->setPriceMappings($priceMappings)
            ->setPriceTableName($priceTableName)
            ->setSkus($skus)
            ->setType($type);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ExternalPriceTable
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get priceMappings value
     * @return \StructType\PriceMapping[]|null
     */
    public function getPriceMappings()
    {
        return $this->priceMappings;
    }
    /**
     * Set priceMappings value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceMapping[] $priceMappings
     * @return \StructType\ExternalPriceTable
     */
    public function setPriceMappings(array $priceMappings = array())
    {
        foreach ($priceMappings as $externalPriceTablePriceMappingsItem) {
            // validation for constraint: itemType
            if (!$externalPriceTablePriceMappingsItem instanceof \StructType\PriceMapping) {
                throw new \InvalidArgumentException(sprintf('The priceMappings property can only contain items of \StructType\PriceMapping, "%s" given', is_object($externalPriceTablePriceMappingsItem) ? get_class($externalPriceTablePriceMappingsItem) : gettype($externalPriceTablePriceMappingsItem)), __LINE__);
            }
        }
        $this->priceMappings = $priceMappings;
        return $this;
    }
    /**
     * Add item to priceMappings value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceMapping $item
     * @return \StructType\ExternalPriceTable
     */
    public function addToPriceMappings(\StructType\PriceMapping $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceMapping) {
            throw new \InvalidArgumentException(sprintf('The priceMappings property can only contain items of \StructType\PriceMapping, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->priceMappings[] = $item;
        return $this;
    }
    /**
     * Get priceTableName value
     * @return string|null
     */
    public function getPriceTableName()
    {
        return $this->priceTableName;
    }
    /**
     * Set priceTableName value
     * @param string $priceTableName
     * @return \StructType\ExternalPriceTable
     */
    public function setPriceTableName($priceTableName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTableName) && !is_string($priceTableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceTableName)), __LINE__);
        }
        $this->priceTableName = $priceTableName;
        return $this;
    }
    /**
     * Get skus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Sku[]|null
     */
    public function getSkus()
    {
        return isset($this->skus) ? $this->skus : null;
    }
    /**
     * Set skus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sku[] $skus
     * @return \StructType\ExternalPriceTable
     */
    public function setSkus(array $skus = array())
    {
        foreach ($skus as $externalPriceTableSkusItem) {
            // validation for constraint: itemType
            if (!$externalPriceTableSkusItem instanceof \StructType\Sku) {
                throw new \InvalidArgumentException(sprintf('The skus property can only contain items of \StructType\Sku, "%s" given', is_object($externalPriceTableSkusItem) ? get_class($externalPriceTableSkusItem) : gettype($externalPriceTableSkusItem)), __LINE__);
            }
        }
        if (is_null($skus) || (is_array($skus) && empty($skus))) {
            unset($this->skus);
        } else {
            $this->skus = $skus;
        }
        return $this;
    }
    /**
     * Add item to skus value
     * @throws \InvalidArgumentException
     * @param \StructType\Sku $item
     * @return \StructType\ExternalPriceTable
     */
    public function addToSkus(\StructType\Sku $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sku) {
            throw new \InvalidArgumentException(sprintf('The skus property can only contain items of \StructType\Sku, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->skus[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ExternalPriceTable
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalPriceTable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
