<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalCustomer StructType
 * @subpackage Structs
 */
class ExternalCustomer extends AbstractStructBase
{
    /**
     * The billingAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalAddress
     */
    public $billingAddress;
    /**
     * The billingAddresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalAddress[]
     */
    public $billingAddresses;
    /**
     * The customerTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customerTypeId;
    /**
     * The externalOrders
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalOrder[]
     */
    public $externalOrders;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The internalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $internalId;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The middleInitial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middleInitial;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The paymentMethods
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentMethod[]
     */
    public $paymentMethods;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The shippingAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalAddress
     */
    public $shippingAddress;
    /**
     * The shippingAddresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalAddress[]
     */
    public $shippingAddresses;
    /**
     * The suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $suffix;
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The vendorId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vendorId;
    /**
     * Constructor method for externalCustomer
     * @uses ExternalCustomer::setBillingAddress()
     * @uses ExternalCustomer::setBillingAddresses()
     * @uses ExternalCustomer::setCustomerTypeId()
     * @uses ExternalCustomer::setExternalOrders()
     * @uses ExternalCustomer::setFirstName()
     * @uses ExternalCustomer::setInternalId()
     * @uses ExternalCustomer::setLastName()
     * @uses ExternalCustomer::setMiddleInitial()
     * @uses ExternalCustomer::setPassword()
     * @uses ExternalCustomer::setPaymentMethods()
     * @uses ExternalCustomer::setPrefix()
     * @uses ExternalCustomer::setShippingAddress()
     * @uses ExternalCustomer::setShippingAddresses()
     * @uses ExternalCustomer::setSuffix()
     * @uses ExternalCustomer::setUserName()
     * @uses ExternalCustomer::setVendorId()
     * @param \StructType\ExternalAddress $billingAddress
     * @param \StructType\ExternalAddress[] $billingAddresses
     * @param int $customerTypeId
     * @param \StructType\ExternalOrder[] $externalOrders
     * @param string $firstName
     * @param int $internalId
     * @param string $lastName
     * @param string $middleInitial
     * @param string $password
     * @param \StructType\PaymentMethod[] $paymentMethods
     * @param string $prefix
     * @param \StructType\ExternalAddress $shippingAddress
     * @param \StructType\ExternalAddress[] $shippingAddresses
     * @param string $suffix
     * @param string $userName
     * @param int $vendorId
     */
    public function __construct(\StructType\ExternalAddress $billingAddress = null, array $billingAddresses = array(), $customerTypeId = null, array $externalOrders = array(), $firstName = null, $internalId = null, $lastName = null, $middleInitial = null, $password = null, array $paymentMethods = array(), $prefix = null, \StructType\ExternalAddress $shippingAddress = null, array $shippingAddresses = array(), $suffix = null, $userName = null, $vendorId = null)
    {
        $this
            ->setBillingAddress($billingAddress)
            ->setBillingAddresses($billingAddresses)
            ->setCustomerTypeId($customerTypeId)
            ->setExternalOrders($externalOrders)
            ->setFirstName($firstName)
            ->setInternalId($internalId)
            ->setLastName($lastName)
            ->setMiddleInitial($middleInitial)
            ->setPassword($password)
            ->setPaymentMethods($paymentMethods)
            ->setPrefix($prefix)
            ->setShippingAddress($shippingAddress)
            ->setShippingAddresses($shippingAddresses)
            ->setSuffix($suffix)
            ->setUserName($userName)
            ->setVendorId($vendorId);
    }
    /**
     * Get billingAddress value
     * @return \StructType\ExternalAddress|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\ExternalAddress $billingAddress
     * @return \StructType\ExternalCustomer
     */
    public function setBillingAddress(\StructType\ExternalAddress $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billingAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalAddress[]|null
     */
    public function getBillingAddresses()
    {
        return isset($this->billingAddresses) ? $this->billingAddresses : null;
    }
    /**
     * Set billingAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalAddress[] $billingAddresses
     * @return \StructType\ExternalCustomer
     */
    public function setBillingAddresses(array $billingAddresses = array())
    {
        foreach ($billingAddresses as $externalCustomerBillingAddressesItem) {
            // validation for constraint: itemType
            if (!$externalCustomerBillingAddressesItem instanceof \StructType\ExternalAddress) {
                throw new \InvalidArgumentException(sprintf('The billingAddresses property can only contain items of \StructType\ExternalAddress, "%s" given', is_object($externalCustomerBillingAddressesItem) ? get_class($externalCustomerBillingAddressesItem) : gettype($externalCustomerBillingAddressesItem)), __LINE__);
            }
        }
        if (is_null($billingAddresses) || (is_array($billingAddresses) && empty($billingAddresses))) {
            unset($this->billingAddresses);
        } else {
            $this->billingAddresses = $billingAddresses;
        }
        return $this;
    }
    /**
     * Add item to billingAddresses value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalAddress $item
     * @return \StructType\ExternalCustomer
     */
    public function addToBillingAddresses(\StructType\ExternalAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalAddress) {
            throw new \InvalidArgumentException(sprintf('The billingAddresses property can only contain items of \StructType\ExternalAddress, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->billingAddresses[] = $item;
        return $this;
    }
    /**
     * Get customerTypeId value
     * @return int|null
     */
    public function getCustomerTypeId()
    {
        return $this->customerTypeId;
    }
    /**
     * Set customerTypeId value
     * @param int $customerTypeId
     * @return \StructType\ExternalCustomer
     */
    public function setCustomerTypeId($customerTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($customerTypeId) && !is_numeric($customerTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerTypeId)), __LINE__);
        }
        $this->customerTypeId = $customerTypeId;
        return $this;
    }
    /**
     * Get externalOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalOrder[]|null
     */
    public function getExternalOrders()
    {
        return isset($this->externalOrders) ? $this->externalOrders : null;
    }
    /**
     * Set externalOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalOrder[] $externalOrders
     * @return \StructType\ExternalCustomer
     */
    public function setExternalOrders(array $externalOrders = array())
    {
        foreach ($externalOrders as $externalCustomerExternalOrdersItem) {
            // validation for constraint: itemType
            if (!$externalCustomerExternalOrdersItem instanceof \StructType\ExternalOrder) {
                throw new \InvalidArgumentException(sprintf('The externalOrders property can only contain items of \StructType\ExternalOrder, "%s" given', is_object($externalCustomerExternalOrdersItem) ? get_class($externalCustomerExternalOrdersItem) : gettype($externalCustomerExternalOrdersItem)), __LINE__);
            }
        }
        if (is_null($externalOrders) || (is_array($externalOrders) && empty($externalOrders))) {
            unset($this->externalOrders);
        } else {
            $this->externalOrders = $externalOrders;
        }
        return $this;
    }
    /**
     * Add item to externalOrders value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalOrder $item
     * @return \StructType\ExternalCustomer
     */
    public function addToExternalOrders(\StructType\ExternalOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalOrder) {
            throw new \InvalidArgumentException(sprintf('The externalOrders property can only contain items of \StructType\ExternalOrder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalOrders[] = $item;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\ExternalCustomer
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get internalId value
     * @return int|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param int $internalId
     * @return \StructType\ExternalCustomer
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: int
        if (!is_null($internalId) && !is_numeric($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\ExternalCustomer
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get middleInitial value
     * @return string|null
     */
    public function getMiddleInitial()
    {
        return $this->middleInitial;
    }
    /**
     * Set middleInitial value
     * @param string $middleInitial
     * @return \StructType\ExternalCustomer
     */
    public function setMiddleInitial($middleInitial = null)
    {
        // validation for constraint: string
        if (!is_null($middleInitial) && !is_string($middleInitial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleInitial)), __LINE__);
        }
        $this->middleInitial = $middleInitial;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\ExternalCustomer
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get paymentMethods value
     * @return \StructType\PaymentMethod[]|null
     */
    public function getPaymentMethods()
    {
        return $this->paymentMethods;
    }
    /**
     * Set paymentMethods value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethod[] $paymentMethods
     * @return \StructType\ExternalCustomer
     */
    public function setPaymentMethods(array $paymentMethods = array())
    {
        foreach ($paymentMethods as $externalCustomerPaymentMethodsItem) {
            // validation for constraint: itemType
            if (!$externalCustomerPaymentMethodsItem instanceof \StructType\PaymentMethod) {
                throw new \InvalidArgumentException(sprintf('The paymentMethods property can only contain items of \StructType\PaymentMethod, "%s" given', is_object($externalCustomerPaymentMethodsItem) ? get_class($externalCustomerPaymentMethodsItem) : gettype($externalCustomerPaymentMethodsItem)), __LINE__);
            }
        }
        $this->paymentMethods = $paymentMethods;
        return $this;
    }
    /**
     * Add item to paymentMethods value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethod $item
     * @return \StructType\ExternalCustomer
     */
    public function addToPaymentMethods(\StructType\PaymentMethod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentMethod) {
            throw new \InvalidArgumentException(sprintf('The paymentMethods property can only contain items of \StructType\PaymentMethod, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->paymentMethods[] = $item;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \StructType\ExternalCustomer
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\ExternalAddress|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\ExternalAddress $shippingAddress
     * @return \StructType\ExternalCustomer
     */
    public function setShippingAddress(\StructType\ExternalAddress $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get shippingAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalAddress[]|null
     */
    public function getShippingAddresses()
    {
        return isset($this->shippingAddresses) ? $this->shippingAddresses : null;
    }
    /**
     * Set shippingAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalAddress[] $shippingAddresses
     * @return \StructType\ExternalCustomer
     */
    public function setShippingAddresses(array $shippingAddresses = array())
    {
        foreach ($shippingAddresses as $externalCustomerShippingAddressesItem) {
            // validation for constraint: itemType
            if (!$externalCustomerShippingAddressesItem instanceof \StructType\ExternalAddress) {
                throw new \InvalidArgumentException(sprintf('The shippingAddresses property can only contain items of \StructType\ExternalAddress, "%s" given', is_object($externalCustomerShippingAddressesItem) ? get_class($externalCustomerShippingAddressesItem) : gettype($externalCustomerShippingAddressesItem)), __LINE__);
            }
        }
        if (is_null($shippingAddresses) || (is_array($shippingAddresses) && empty($shippingAddresses))) {
            unset($this->shippingAddresses);
        } else {
            $this->shippingAddresses = $shippingAddresses;
        }
        return $this;
    }
    /**
     * Add item to shippingAddresses value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalAddress $item
     * @return \StructType\ExternalCustomer
     */
    public function addToShippingAddresses(\StructType\ExternalAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalAddress) {
            throw new \InvalidArgumentException(sprintf('The shippingAddresses property can only contain items of \StructType\ExternalAddress, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shippingAddresses[] = $item;
        return $this;
    }
    /**
     * Get suffix value
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->suffix;
    }
    /**
     * Set suffix value
     * @param string $suffix
     * @return \StructType\ExternalCustomer
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suffix)), __LINE__);
        }
        $this->suffix = $suffix;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\ExternalCustomer
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get vendorId value
     * @return int|null
     */
    public function getVendorId()
    {
        return $this->vendorId;
    }
    /**
     * Set vendorId value
     * @param int $vendorId
     * @return \StructType\ExternalCustomer
     */
    public function setVendorId($vendorId = null)
    {
        // validation for constraint: int
        if (!is_null($vendorId) && !is_numeric($vendorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vendorId)), __LINE__);
        }
        $this->vendorId = $vendorId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
