<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalCriteriaGroup StructType
 * @subpackage Structs
 */
class ExternalCriteriaGroup extends AbstractStructBase
{
    /**
     * The allRequiredInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $allRequiredInd;
    /**
     * The externalCriterias
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExternalCriteria[]
     */
    public $externalCriterias;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The requiredInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requiredInd;
    /**
     * Constructor method for externalCriteriaGroup
     * @uses ExternalCriteriaGroup::setAllRequiredInd()
     * @uses ExternalCriteriaGroup::setExternalCriterias()
     * @uses ExternalCriteriaGroup::setId()
     * @uses ExternalCriteriaGroup::setRequiredInd()
     * @param int $allRequiredInd
     * @param \StructType\ExternalCriteria[] $externalCriterias
     * @param int $id
     * @param int $requiredInd
     */
    public function __construct($allRequiredInd = null, array $externalCriterias = array(), $id = null, $requiredInd = null)
    {
        $this
            ->setAllRequiredInd($allRequiredInd)
            ->setExternalCriterias($externalCriterias)
            ->setId($id)
            ->setRequiredInd($requiredInd);
    }
    /**
     * Get allRequiredInd value
     * @return int|null
     */
    public function getAllRequiredInd()
    {
        return $this->allRequiredInd;
    }
    /**
     * Set allRequiredInd value
     * @param int $allRequiredInd
     * @return \StructType\ExternalCriteriaGroup
     */
    public function setAllRequiredInd($allRequiredInd = null)
    {
        // validation for constraint: int
        if (!is_null($allRequiredInd) && !is_numeric($allRequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allRequiredInd)), __LINE__);
        }
        $this->allRequiredInd = $allRequiredInd;
        return $this;
    }
    /**
     * Get externalCriterias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExternalCriteria[]|null
     */
    public function getExternalCriterias()
    {
        return isset($this->externalCriterias) ? $this->externalCriterias : null;
    }
    /**
     * Set externalCriterias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalCriteria[] $externalCriterias
     * @return \StructType\ExternalCriteriaGroup
     */
    public function setExternalCriterias(array $externalCriterias = array())
    {
        foreach ($externalCriterias as $externalCriteriaGroupExternalCriteriasItem) {
            // validation for constraint: itemType
            if (!$externalCriteriaGroupExternalCriteriasItem instanceof \StructType\ExternalCriteria) {
                throw new \InvalidArgumentException(sprintf('The externalCriterias property can only contain items of \StructType\ExternalCriteria, "%s" given', is_object($externalCriteriaGroupExternalCriteriasItem) ? get_class($externalCriteriaGroupExternalCriteriasItem) : gettype($externalCriteriaGroupExternalCriteriasItem)), __LINE__);
            }
        }
        if (is_null($externalCriterias) || (is_array($externalCriterias) && empty($externalCriterias))) {
            unset($this->externalCriterias);
        } else {
            $this->externalCriterias = $externalCriterias;
        }
        return $this;
    }
    /**
     * Add item to externalCriterias value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalCriteria $item
     * @return \StructType\ExternalCriteriaGroup
     */
    public function addToExternalCriterias(\StructType\ExternalCriteria $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalCriteria) {
            throw new \InvalidArgumentException(sprintf('The externalCriterias property can only contain items of \StructType\ExternalCriteria, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->externalCriterias[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ExternalCriteriaGroup
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get requiredInd value
     * @return int|null
     */
    public function getRequiredInd()
    {
        return $this->requiredInd;
    }
    /**
     * Set requiredInd value
     * @param int $requiredInd
     * @return \StructType\ExternalCriteriaGroup
     */
    public function setRequiredInd($requiredInd = null)
    {
        // validation for constraint: int
        if (!is_null($requiredInd) && !is_numeric($requiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requiredInd)), __LINE__);
        }
        $this->requiredInd = $requiredInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExternalCriteriaGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
