<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for costData StructType
 * @subpackage Structs
 */
class CostData extends AbstractStructBase
{
    /**
     * The applicablePromos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExternalPromo[]
     */
    public $applicablePromos;
    /**
     * The discountAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountAmount;
    /**
     * The feeCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $feeCost;
    /**
     * The insuranceFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $insuranceFee;
    /**
     * The merchCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $merchCost;
    /**
     * The messages
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Message[]
     */
    public $messages;
    /**
     * The oversizedShipFeeTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $oversizedShipFeeTotal;
    /**
     * The promoAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $promoAmount;
    /**
     * The retailCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $retailCost;
    /**
     * The shippingCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $shippingCost;
    /**
     * The taxCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxCost;
    /**
     * The totalCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalCost;
    /**
     * Constructor method for costData
     * @uses CostData::setApplicablePromos()
     * @uses CostData::setDiscountAmount()
     * @uses CostData::setFeeCost()
     * @uses CostData::setInsuranceFee()
     * @uses CostData::setMerchCost()
     * @uses CostData::setMessages()
     * @uses CostData::setOversizedShipFeeTotal()
     * @uses CostData::setPromoAmount()
     * @uses CostData::setRetailCost()
     * @uses CostData::setShippingCost()
     * @uses CostData::setTaxCost()
     * @uses CostData::setTotalCost()
     * @param \StructType\ExternalPromo[] $applicablePromos
     * @param float $discountAmount
     * @param float $feeCost
     * @param float $insuranceFee
     * @param float $merchCost
     * @param \StructType\Message[] $messages
     * @param float $oversizedShipFeeTotal
     * @param float $promoAmount
     * @param float $retailCost
     * @param float $shippingCost
     * @param float $taxCost
     * @param float $totalCost
     */
    public function __construct(array $applicablePromos = array(), $discountAmount = null, $feeCost = null, $insuranceFee = null, $merchCost = null, array $messages = array(), $oversizedShipFeeTotal = null, $promoAmount = null, $retailCost = null, $shippingCost = null, $taxCost = null, $totalCost = null)
    {
        $this
            ->setApplicablePromos($applicablePromos)
            ->setDiscountAmount($discountAmount)
            ->setFeeCost($feeCost)
            ->setInsuranceFee($insuranceFee)
            ->setMerchCost($merchCost)
            ->setMessages($messages)
            ->setOversizedShipFeeTotal($oversizedShipFeeTotal)
            ->setPromoAmount($promoAmount)
            ->setRetailCost($retailCost)
            ->setShippingCost($shippingCost)
            ->setTaxCost($taxCost)
            ->setTotalCost($totalCost);
    }
    /**
     * Get applicablePromos value
     * @return \StructType\ExternalPromo[]|null
     */
    public function getApplicablePromos()
    {
        return $this->applicablePromos;
    }
    /**
     * Set applicablePromos value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalPromo[] $applicablePromos
     * @return \StructType\CostData
     */
    public function setApplicablePromos(array $applicablePromos = array())
    {
        foreach ($applicablePromos as $costDataApplicablePromosItem) {
            // validation for constraint: itemType
            if (!$costDataApplicablePromosItem instanceof \StructType\ExternalPromo) {
                throw new \InvalidArgumentException(sprintf('The applicablePromos property can only contain items of \StructType\ExternalPromo, "%s" given', is_object($costDataApplicablePromosItem) ? get_class($costDataApplicablePromosItem) : gettype($costDataApplicablePromosItem)), __LINE__);
            }
        }
        $this->applicablePromos = $applicablePromos;
        return $this;
    }
    /**
     * Add item to applicablePromos value
     * @throws \InvalidArgumentException
     * @param \StructType\ExternalPromo $item
     * @return \StructType\CostData
     */
    public function addToApplicablePromos(\StructType\ExternalPromo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExternalPromo) {
            throw new \InvalidArgumentException(sprintf('The applicablePromos property can only contain items of \StructType\ExternalPromo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->applicablePromos[] = $item;
        return $this;
    }
    /**
     * Get discountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }
    /**
     * Set discountAmount value
     * @param float $discountAmount
     * @return \StructType\CostData
     */
    public function setDiscountAmount($discountAmount = null)
    {
        $this->discountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get feeCost value
     * @return float|null
     */
    public function getFeeCost()
    {
        return $this->feeCost;
    }
    /**
     * Set feeCost value
     * @param float $feeCost
     * @return \StructType\CostData
     */
    public function setFeeCost($feeCost = null)
    {
        $this->feeCost = $feeCost;
        return $this;
    }
    /**
     * Get insuranceFee value
     * @return float|null
     */
    public function getInsuranceFee()
    {
        return $this->insuranceFee;
    }
    /**
     * Set insuranceFee value
     * @param float $insuranceFee
     * @return \StructType\CostData
     */
    public function setInsuranceFee($insuranceFee = null)
    {
        $this->insuranceFee = $insuranceFee;
        return $this;
    }
    /**
     * Get merchCost value
     * @return float|null
     */
    public function getMerchCost()
    {
        return $this->merchCost;
    }
    /**
     * Set merchCost value
     * @param float $merchCost
     * @return \StructType\CostData
     */
    public function setMerchCost($merchCost = null)
    {
        $this->merchCost = $merchCost;
        return $this;
    }
    /**
     * Get messages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Message[]|null
     */
    public function getMessages()
    {
        return isset($this->messages) ? $this->messages : null;
    }
    /**
     * Set messages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Message[] $messages
     * @return \StructType\CostData
     */
    public function setMessages(array $messages = array())
    {
        foreach ($messages as $costDataMessagesItem) {
            // validation for constraint: itemType
            if (!$costDataMessagesItem instanceof \StructType\Message) {
                throw new \InvalidArgumentException(sprintf('The messages property can only contain items of \StructType\Message, "%s" given', is_object($costDataMessagesItem) ? get_class($costDataMessagesItem) : gettype($costDataMessagesItem)), __LINE__);
            }
        }
        if (is_null($messages) || (is_array($messages) && empty($messages))) {
            unset($this->messages);
        } else {
            $this->messages = $messages;
        }
        return $this;
    }
    /**
     * Add item to messages value
     * @throws \InvalidArgumentException
     * @param \StructType\Message $item
     * @return \StructType\CostData
     */
    public function addToMessages(\StructType\Message $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Message) {
            throw new \InvalidArgumentException(sprintf('The messages property can only contain items of \StructType\Message, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->messages[] = $item;
        return $this;
    }
    /**
     * Get oversizedShipFeeTotal value
     * @return float|null
     */
    public function getOversizedShipFeeTotal()
    {
        return $this->oversizedShipFeeTotal;
    }
    /**
     * Set oversizedShipFeeTotal value
     * @param float $oversizedShipFeeTotal
     * @return \StructType\CostData
     */
    public function setOversizedShipFeeTotal($oversizedShipFeeTotal = null)
    {
        $this->oversizedShipFeeTotal = $oversizedShipFeeTotal;
        return $this;
    }
    /**
     * Get promoAmount value
     * @return float|null
     */
    public function getPromoAmount()
    {
        return $this->promoAmount;
    }
    /**
     * Set promoAmount value
     * @param float $promoAmount
     * @return \StructType\CostData
     */
    public function setPromoAmount($promoAmount = null)
    {
        $this->promoAmount = $promoAmount;
        return $this;
    }
    /**
     * Get retailCost value
     * @return float|null
     */
    public function getRetailCost()
    {
        return $this->retailCost;
    }
    /**
     * Set retailCost value
     * @param float $retailCost
     * @return \StructType\CostData
     */
    public function setRetailCost($retailCost = null)
    {
        $this->retailCost = $retailCost;
        return $this;
    }
    /**
     * Get shippingCost value
     * @return float|null
     */
    public function getShippingCost()
    {
        return $this->shippingCost;
    }
    /**
     * Set shippingCost value
     * @param float $shippingCost
     * @return \StructType\CostData
     */
    public function setShippingCost($shippingCost = null)
    {
        $this->shippingCost = $shippingCost;
        return $this;
    }
    /**
     * Get taxCost value
     * @return float|null
     */
    public function getTaxCost()
    {
        return $this->taxCost;
    }
    /**
     * Set taxCost value
     * @param float $taxCost
     * @return \StructType\CostData
     */
    public function setTaxCost($taxCost = null)
    {
        $this->taxCost = $taxCost;
        return $this;
    }
    /**
     * Get totalCost value
     * @return float|null
     */
    public function getTotalCost()
    {
        return $this->totalCost;
    }
    /**
     * Set totalCost value
     * @param float $totalCost
     * @return \StructType\CostData
     */
    public function setTotalCost($totalCost = null)
    {
        $this->totalCost = $totalCost;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CostData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
