<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for complexDescription StructType
 * @subpackage Structs
 */
class ComplexDescription extends AbstractStructBase
{
    /**
     * The descText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descText;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The shortDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shortDescription;
    /**
     * Constructor method for complexDescription
     * @uses ComplexDescription::setDescText()
     * @uses ComplexDescription::setId()
     * @uses ComplexDescription::setName()
     * @uses ComplexDescription::setShortDescription()
     * @param string $descText
     * @param int $id
     * @param string $name
     * @param string $shortDescription
     */
    public function __construct($descText = null, $id = null, $name = null, $shortDescription = null)
    {
        $this
            ->setDescText($descText)
            ->setId($id)
            ->setName($name)
            ->setShortDescription($shortDescription);
    }
    /**
     * Get descText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->descText;
    }
    /**
     * Set descText value
     * @param string $descText
     * @return \StructType\ComplexDescription
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descText)), __LINE__);
        }
        $this->descText = $descText;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ComplexDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ComplexDescription
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get shortDescription value
     * @return string|null
     */
    public function getShortDescription()
    {
        return $this->shortDescription;
    }
    /**
     * Set shortDescription value
     * @param string $shortDescription
     * @return \StructType\ComplexDescription
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortDescription)), __LINE__);
        }
        $this->shortDescription = $shortDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ComplexDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
