<?php

namespace EnumType;

/**
 * This class stands for templateVariableType EnumType
 * @subpackage Enumerations
 */
class TemplateVariableType
{
    /**
     * Constant for value 'IMAGE'
     * @return string 'IMAGE'
     */
    const VALUE_IMAGE = 'IMAGE';
    /**
     * Constant for value 'TEXT'
     * @return string 'TEXT'
     */
    const VALUE_TEXT = 'TEXT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IMAGE
     * @uses self::VALUE_TEXT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMAGE,
            self::VALUE_TEXT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
