<?php

namespace EnumType;

/**
 * This class stands for operatorTypes EnumType
 * @subpackage Enumerations
 */
class OperatorTypes
{
    /**
     * Constant for value 'GREATER_THAN'
     * @return string 'GREATER_THAN'
     */
    const VALUE_GREATER_THAN = 'GREATER_THAN';
    /**
     * Constant for value 'LESS_THAN'
     * @return string 'LESS_THAN'
     */
    const VALUE_LESS_THAN = 'LESS_THAN';
    /**
     * Constant for value 'GREATER_THAN_EQUAL'
     * @return string 'GREATER_THAN_EQUAL'
     */
    const VALUE_GREATER_THAN_EQUAL = 'GREATER_THAN_EQUAL';
    /**
     * Constant for value 'LESS_THAN_EQUAL'
     * @return string 'LESS_THAN_EQUAL'
     */
    const VALUE_LESS_THAN_EQUAL = 'LESS_THAN_EQUAL';
    /**
     * Constant for value 'EQUAL'
     * @return string 'EQUAL'
     */
    const VALUE_EQUAL = 'EQUAL';
    /**
     * Constant for value 'NOT_EQUAL'
     * @return string 'NOT_EQUAL'
     */
    const VALUE_NOT_EQUAL = 'NOT_EQUAL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GREATER_THAN
     * @uses self::VALUE_LESS_THAN
     * @uses self::VALUE_GREATER_THAN_EQUAL
     * @uses self::VALUE_LESS_THAN_EQUAL
     * @uses self::VALUE_EQUAL
     * @uses self::VALUE_NOT_EQUAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GREATER_THAN,
            self::VALUE_LESS_THAN,
            self::VALUE_GREATER_THAN_EQUAL,
            self::VALUE_LESS_THAN_EQUAL,
            self::VALUE_EQUAL,
            self::VALUE_NOT_EQUAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
