<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sku StructType
 * @subpackage Structs
 */
class Sku extends AbstractStructBase
{
    /**
     * The productType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * Constructor method for sku
     * @uses Sku::setProductType()
     * @uses Sku::setSku()
     * @param string $productType
     * @param string $sku
     */
    public function __construct($productType = null, $sku = null)
    {
        $this
            ->setProductType($productType)
            ->setSku($sku);
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \StructType\Sku
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productType)), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \StructType\Sku
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Sku
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
