<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeProductFromPackage StructType
 * Meta informations extracted from the WSDL
 * - type: tns:removeProductFromPackage
 * @subpackage Structs
 */
class RemoveProductFromPackage extends AbstractStructBase
{
    /**
     * The userAccessCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userAccessCode;
    /**
     * The packageId
     * @var int
     */
    public $packageId;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * Constructor method for removeProductFromPackage
     * @uses RemoveProductFromPackage::setUserAccessCode()
     * @uses RemoveProductFromPackage::setPackageId()
     * @uses RemoveProductFromPackage::setProductId()
     * @param string $userAccessCode
     * @param int $packageId
     * @param int $productId
     */
    public function __construct($userAccessCode = null, $packageId = null, $productId = null)
    {
        $this
            ->setUserAccessCode($userAccessCode)
            ->setPackageId($packageId)
            ->setProductId($productId);
    }
    /**
     * Get userAccessCode value
     * @return string|null
     */
    public function getUserAccessCode()
    {
        return $this->userAccessCode;
    }
    /**
     * Set userAccessCode value
     * @param string $userAccessCode
     * @return \StructType\RemoveProductFromPackage
     */
    public function setUserAccessCode($userAccessCode = null)
    {
        // validation for constraint: string
        if (!is_null($userAccessCode) && !is_string($userAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userAccessCode)), __LINE__);
        }
        $this->userAccessCode = $userAccessCode;
        return $this;
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \StructType\RemoveProductFromPackage
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !is_numeric($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageId)), __LINE__);
        }
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\RemoveProductFromPackage
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveProductFromPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
