<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printJob StructType
 * @subpackage Structs
 */
class PrintJob extends ExternalProductPackage
{
    /**
     * The substrate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalProduct
     */
    public $substrate;
    /**
     * The template
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Template
     */
    public $template;
    /**
     * Constructor method for printJob
     * @uses PrintJob::setSubstrate()
     * @uses PrintJob::setTemplate()
     * @param \StructType\ExternalProduct $substrate
     * @param \StructType\Template $template
     */
    public function __construct(\StructType\ExternalProduct $substrate = null, \StructType\Template $template = null)
    {
        $this
            ->setSubstrate($substrate)
            ->setTemplate($template);
    }
    /**
     * Get substrate value
     * @return \StructType\ExternalProduct|null
     */
    public function getSubstrate()
    {
        return $this->substrate;
    }
    /**
     * Set substrate value
     * @param \StructType\ExternalProduct $substrate
     * @return \StructType\PrintJob
     */
    public function setSubstrate(\StructType\ExternalProduct $substrate = null)
    {
        $this->substrate = $substrate;
        return $this;
    }
    /**
     * Get template value
     * @return \StructType\Template|null
     */
    public function getTemplate()
    {
        return $this->template;
    }
    /**
     * Set template value
     * @param \StructType\Template $template
     * @return \StructType\PrintJob
     */
    public function setTemplate(\StructType\Template $template = null)
    {
        $this->template = $template;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintJob
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
