<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printAndFramePackage StructType
 * @subpackage Structs
 */
class PrintAndFramePackage extends FramePackage
{
    /**
     * The certificateOfAuth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalProduct
     */
    public $certificateOfAuth;
    /**
     * The hasCustomerSuppliedImage
     * @var bool
     */
    public $hasCustomerSuppliedImage;
    /**
     * The proofStamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExternalProduct
     */
    public $proofStamp;
    /**
     * The stretcherBar
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StretcherBar
     */
    public $stretcherBar;
    /**
     * The substrate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Substrate
     */
    public $substrate;
    /**
     * Constructor method for printAndFramePackage
     * @uses PrintAndFramePackage::setCertificateOfAuth()
     * @uses PrintAndFramePackage::setHasCustomerSuppliedImage()
     * @uses PrintAndFramePackage::setProofStamp()
     * @uses PrintAndFramePackage::setStretcherBar()
     * @uses PrintAndFramePackage::setSubstrate()
     * @param \StructType\ExternalProduct $certificateOfAuth
     * @param bool $hasCustomerSuppliedImage
     * @param \StructType\ExternalProduct $proofStamp
     * @param \StructType\StretcherBar $stretcherBar
     * @param \StructType\Substrate $substrate
     */
    public function __construct(\StructType\ExternalProduct $certificateOfAuth = null, $hasCustomerSuppliedImage = null, \StructType\ExternalProduct $proofStamp = null, \StructType\StretcherBar $stretcherBar = null, \StructType\Substrate $substrate = null)
    {
        $this
            ->setCertificateOfAuth($certificateOfAuth)
            ->setHasCustomerSuppliedImage($hasCustomerSuppliedImage)
            ->setProofStamp($proofStamp)
            ->setStretcherBar($stretcherBar)
            ->setSubstrate($substrate);
    }
    /**
     * Get certificateOfAuth value
     * @return \StructType\ExternalProduct|null
     */
    public function getCertificateOfAuth()
    {
        return $this->certificateOfAuth;
    }
    /**
     * Set certificateOfAuth value
     * @param \StructType\ExternalProduct $certificateOfAuth
     * @return \StructType\PrintAndFramePackage
     */
    public function setCertificateOfAuth(\StructType\ExternalProduct $certificateOfAuth = null)
    {
        $this->certificateOfAuth = $certificateOfAuth;
        return $this;
    }
    /**
     * Get hasCustomerSuppliedImage value
     * @return bool|null
     */
    public function getHasCustomerSuppliedImage()
    {
        return $this->hasCustomerSuppliedImage;
    }
    /**
     * Set hasCustomerSuppliedImage value
     * @param bool $hasCustomerSuppliedImage
     * @return \StructType\PrintAndFramePackage
     */
    public function setHasCustomerSuppliedImage($hasCustomerSuppliedImage = null)
    {
        $this->hasCustomerSuppliedImage = $hasCustomerSuppliedImage;
        return $this;
    }
    /**
     * Get proofStamp value
     * @return \StructType\ExternalProduct|null
     */
    public function getProofStamp()
    {
        return $this->proofStamp;
    }
    /**
     * Set proofStamp value
     * @param \StructType\ExternalProduct $proofStamp
     * @return \StructType\PrintAndFramePackage
     */
    public function setProofStamp(\StructType\ExternalProduct $proofStamp = null)
    {
        $this->proofStamp = $proofStamp;
        return $this;
    }
    /**
     * Get stretcherBar value
     * @return \StructType\StretcherBar|null
     */
    public function getStretcherBar()
    {
        return $this->stretcherBar;
    }
    /**
     * Set stretcherBar value
     * @param \StructType\StretcherBar $stretcherBar
     * @return \StructType\PrintAndFramePackage
     */
    public function setStretcherBar(\StructType\StretcherBar $stretcherBar = null)
    {
        $this->stretcherBar = $stretcherBar;
        return $this;
    }
    /**
     * Get substrate value
     * @return \StructType\Substrate|null
     */
    public function getSubstrate()
    {
        return $this->substrate;
    }
    /**
     * Set substrate value
     * @param \StructType\Substrate $substrate
     * @return \StructType\PrintAndFramePackage
     */
    public function setSubstrate(\StructType\Substrate $substrate = null)
    {
        $this->substrate = $substrate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrintAndFramePackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
